/**
 * This program is an example from the book "Internet
 * programming with Java" by Svetlin Nakov. It is freeware.
 * For more information: http://www.nakov.com/books/inetjava/
 */
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class MainServlet extends HttpServlet {
    public void doGet(HttpServletRequest aRequest,
        HttpServletResponse aResponse)
    throws IOException, ServletException {
        HttpSession session = aRequest.getSession();
        String username = (String) session.getAttribute("USER");
        PrintWriter out = aResponse.getWriter();
        if (username == null) {
            showMainForm("Not authenticated. Please " +
                "<a href='login'>login</a> first.", out);
        } else {
            showMainForm("Welcome, " + username + "!", out);
        }
    }

    private void showMainForm(String aText, PrintWriter aOut) {
        aOut.println("<html>" + aText + "</html>");
    }
}
