/**
 * This program is an example from the book "Internet
 * programming with Java" by Svetlin Nakov. It is freeware.
 * For more information: http://www.nakov.com/books/inetjava/
 */
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class LoginServlet extends HttpServlet {
    public void doGet(HttpServletRequest aRequest,
        HttpServletResponse aResponse)
    throws IOException, ServletException {
        String username = aRequest.getParameter("username");
        String password = aRequest.getParameter("password");
        PrintWriter out = aResponse.getWriter();
        if ((username==null) || (password==null)) {
            showLoginForm("Please login:", out);
        } else if (username.equals(password)) {
            HttpSession session = aRequest.getSession();
            session.setAttribute("USER", username);
            aResponse.sendRedirect("main");
        } else {
            showLoginForm("Invalid login! Try again:", out);
        }
    }

    public void doPost(HttpServletRequest aRequest,
        HttpServletResponse aResponse)
    throws IOException, ServletException {
        doGet(aRequest, aResponse);
    }

    private void showLoginForm(
            String aCaptionText, PrintWriter aOutput) {
        aOutput.println(
            "<html><title>Login</title><body>\n" +
            "<form method='POST' action='login'>\n" +
            aCaptionText + "<br>\n" +
            "<input type='text' name='username'><br>\n" +
            "<input type='password' name='password'><br>\n" +
            "<input type='submit' value='Login'>\n" +
            "</body></form></html>"
        );
    }
}
