package miniforum.action;

import miniforum.data.UserUtils;
import miniforum.IConstants;

import javax.servlet.http.*;
import javax.servlet.ServletException;
import java.io.IOException;

public class LoginServlet extends HttpServlet {
	protected void doPost(HttpServletRequest aRequest,
			HttpServletResponse aResponse)
	        throws ServletException, IOException {
		aRequest.setCharacterEncoding("cp1251");
		String userName =
			aRequest.getParameter(IConstants.USER_PARAM);
		String password =
			aRequest.getParameter(IConstants.PASSWORD_PARAM);
		HttpSession session = aRequest.getSession();
		if (isUserValid(userName, password)) {
			// User valid. Redirect to the last requested page
			UserUtils.setCurrentUser(session, userName);
			String targetURL = (String)
		        session.getAttribute(IConstants.ORIGINAL_URL);
			session.removeAttribute(IConstants.ORIGINAL_URL);
			if (targetURL == null) {
				targetURL = IConstants.MAIN_FORM;
			}
			aResponse.sendRedirect(targetURL);
		} else if (userName != null) {
			// User invalid. Redirect to login form
			session.setAttribute(IConstants.LAST_ERROR,
				"   !");
			aResponse.sendRedirect(IConstants.LOGIN_FORM);
		}
	}

	public static boolean isUserValid(String aUserName,
			String aPassword) {
        boolean valid =
			(aUserName != null) && (aPassword != null) &&
            (aUserName.length() > 0) &&
			(aUserName.equals(aPassword));
		return valid;
	}
}

