package miniforum.action;

import miniforum.data.*;
import miniforum.IConstants;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.IOException;

public class AddMessageServlet extends HttpServlet {
	protected void doPost(HttpServletRequest aRequest,
			HttpServletResponse aResponse)
	        throws ServletException, IOException {
		aRequest.setCharacterEncoding("cp1251");
		HttpSession session = aRequest.getSession();
		ServletContext app = session.getServletContext();
		String currentUser = UserUtils.getCurrentUser(session);
		Message msg = new Message();
		msg.setUser(currentUser);
		String subject = aRequest.getParameter(
		    IConstants.SUBJECT_PARAM);
		msg.setSubject(subject);
		String contents = aRequest.getParameter(
		    IConstants.CONTENTS_PARAM);
		msg.setContents(contents);
		try {
			MessageUtils.addForumMessage(app, msg);
		} catch (IllegalArgumentException iae) {
			session.setAttribute(IConstants.LAST_ERROR,
				" /  !");
		}
		aResponse.sendRedirect("main.jsp");
	}
}
