/**
 * This program is an example from the book "Internet
 * programming with Java" by Svetlin Nakov. It is freeware.
 * For more information: http://www.nakov.com/books/inetjava/
 */
import java.io.*;
import java.net.*;

public class AltaVistaSearch {
    public static void main(String[] args)
    throws Exception {
        URL url = new URL("http://www.altavista.com/search");

        // Send request
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        PrintWriter out = new PrintWriter(
            connection.getOutputStream());
        String query =
            URLEncoder.encode("Svetlin Nakov", "UTF-8");
        out.println("q=" + query);
        out.close();

        // Retrieve response
        BufferedReader in = new BufferedReader(
            new InputStreamReader(
                connection.getInputStream()));
        String line;
        while ((line = in.readLine()) != null)
            System.out.println(line);
        in.close();
    }
}