/**
 * This program is an example from the book "Internet
 * programming with Java" by Svetlin Nakov. It is freeware.
 * For more information: http://www.nakov.com/books/inetjava/
 */
import java.io.*;
import java.lang.*;

public class TextFileLineNumberInserter {
    public static void main(String[] args) throws IOException {
        FileReader inFile = new FileReader("input.txt");
        BufferedReader in = new BufferedReader(inFile);

        FileWriter outFile = new FileWriter("output.txt");
        PrintWriter out = new PrintWriter(outFile);

        int lineNumberCounter = 0;
        String line;
        while ( (line=in.readLine()) != null ) {
            lineNumberCounter++;
            out.println(lineNumberCounter + " " + line);
        }

        in.close();
        out.close();
    }
}