﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.CodeAnalysis;
using Microsoft.CodeAnalysis.CodeFixes;

namespace Roslynator.CodeFixes;

internal class FixAllDiagnosticProvider : FixAllContext.DiagnosticProvider
{
    private readonly ImmutableArray<Diagnostic> _diagnostics;

    public FixAllDiagnosticProvider(ImmutableArray<Diagnostic> diagnostics)
    {
        _diagnostics = diagnostics;
    }

    public override Task<IEnumerable<Diagnostic>> GetAllDiagnosticsAsync(Project project, CancellationToken cancellationToken)
    {
        return Task.FromResult<IEnumerable<Diagnostic>>(_diagnostics);
    }

    public override async Task<IEnumerable<Diagnostic>> GetDocumentDiagnosticsAsync(Document document, CancellationToken cancellationToken)
    {
        SyntaxTree tree = (await document.GetSyntaxTreeAsync(cancellationToken).ConfigureAwait(false))!;

        return GetDocumentDiagnostics();

        IEnumerable<Diagnostic> GetDocumentDiagnostics()
        {
            foreach (Diagnostic diagnostic in _diagnostics)
            {
                if (diagnostic.Location.IsInSource
                    && diagnostic.Location.SourceTree == tree)
                {
                    yield return diagnostic;
                }
            }
        }
    }

    public override Task<IEnumerable<Diagnostic>> GetProjectDiagnosticsAsync(Project project, CancellationToken cancellationToken)
    {
        throw new NotSupportedException();
    }
}
