﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Threading.Tasks;
using Microsoft.CodeAnalysis;
using Microsoft.CodeAnalysis.CSharp.Syntax;

namespace Roslynator.CSharp.Refactorings;

internal static class EventDeclarationRefactoring
{
    public static async Task ComputeRefactoringsAsync(RefactoringContext context, EventDeclarationSyntax eventDeclaration)
    {
        if (context.IsRefactoringEnabled(RefactoringDescriptors.CopyDocumentationCommentFromBaseMember)
            && eventDeclaration.HeaderSpan().Contains(context.Span)
            && !eventDeclaration.HasDocumentationComment())
        {
            SemanticModel semanticModel = await context.GetSemanticModelAsync().ConfigureAwait(false);
            CopyDocumentationCommentFromBaseMemberRefactoring.ComputeRefactoring(context, eventDeclaration, semanticModel);
        }

        if (context.IsRefactoringEnabled(RefactoringDescriptors.AddMemberToInterface)
            && context.Span.IsEmptyAndContainedInSpanOrBetweenSpans(eventDeclaration.Identifier))
        {
            SemanticModel semanticModel = await context.GetSemanticModelAsync().ConfigureAwait(false);

            AddMemberToInterfaceRefactoring.ComputeRefactoring(context, eventDeclaration, semanticModel);
        }
    }
}
