﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// <auto-generated>

namespace Roslynator.CSharp.Refactorings
{
    public static class RefactoringDescriptors
    {
        public static RefactoringDescriptor AddAllPropertiesToInitializer = new RefactoringDescriptor("RR0216", "roslynator_refactoring.add_all_properties_to_initializer.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddArgumentName = new RefactoringDescriptor("RR0011", "roslynator_refactoring.add_argument_name.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddBraces = new RefactoringDescriptor("RR0002", "roslynator_refactoring.add_braces.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddBracesToIfElse = new RefactoringDescriptor("RR0003", "roslynator_refactoring.add_braces_to_if_else.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddBracesToSwitchSection = new RefactoringDescriptor("RR0004", "roslynator_refactoring.add_braces_to_switch_section.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddBracesToSwitchSections = new RefactoringDescriptor("RR0005", "roslynator_refactoring.add_braces_to_switch_sections.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddDefaultValueToParameter = new RefactoringDescriptor("RR0007", "roslynator_refactoring.add_default_value_to_parameter.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddEmptyLineBetweenDeclarations = new RefactoringDescriptor("RR0205", "roslynator_refactoring.add_empty_line_between_declarations.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddExceptionElementToDocumentationComment = new RefactoringDescriptor("RR0009", "roslynator_refactoring.add_exception_element_to_documentation_comment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddGenericParameterToDeclaration = new RefactoringDescriptor("RR0178", "roslynator_refactoring.add_generic_parameter_to_declaration.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddMemberToInterface = new RefactoringDescriptor("RR0195", "roslynator_refactoring.add_member_to_interface.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddMissingCasesToSwitchStatement = new RefactoringDescriptor("RR0059", "roslynator_refactoring.add_missing_cases_to_switch.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddParameterToInterfaceMember = new RefactoringDescriptor("RR0213", "roslynator_refactoring.add_parameter_to_interface_member.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddTagToDocumentationComment = new RefactoringDescriptor("RR0208", "roslynator_refactoring.add_tag_to_documentation_comment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddUsingDirective = new RefactoringDescriptor("RR0013", "roslynator_refactoring.add_using_directive.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor AddUsingStaticDirective = new RefactoringDescriptor("RR0014", "roslynator_refactoring.add_using_static_directive.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CallExtensionMethodAsInstanceMethod = new RefactoringDescriptor("RR0016", "roslynator_refactoring.call_extension_method_as_instance_method.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CallIndexOfInsteadOfContains = new RefactoringDescriptor("RR0144", "roslynator_refactoring.call_indexof_instead_of_contains.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ChangeAccessibility = new RefactoringDescriptor("RR0186", "roslynator_refactoring.change_accessibility.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ChangeMethodReturnTypeToVoid = new RefactoringDescriptor("RR0021", "roslynator_refactoring.change_method_return_type_to_void.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ChangeTypeAccordingToExpression = new RefactoringDescriptor("RR0022", "roslynator_refactoring.change_type_according_to_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CheckExpressionForNull = new RefactoringDescriptor("RR0024", "roslynator_refactoring.check_expression_for_null.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CheckParameterForNull = new RefactoringDescriptor("RR0025", "roslynator_refactoring.check_parameter_for_null.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CommentOutMemberDeclaration = new RefactoringDescriptor("RR0027", "roslynator_refactoring.comment_out_member_declaration.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CommentOutStatement = new RefactoringDescriptor("RR0028", "roslynator_refactoring.comment_out_statement.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertAutoPropertyToFullProperty = new RefactoringDescriptor("RR0041", "roslynator_refactoring.convert_auto_property_to_full_property.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertAutoPropertyToFullPropertyWithoutBackingField = new RefactoringDescriptor("RR0040", "roslynator_refactoring.convert_auto_property_to_full_property_without_backing_field.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertBlockBodyToExpressionBody = new RefactoringDescriptor("RR0169", "roslynator_refactoring.convert_block_body_to_expression_body.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertCommentToDocumentationComment = new RefactoringDescriptor("RR0192", "roslynator_refactoring.convert_comment_to_documentation_comment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertConditionalExpressionToIfElse = new RefactoringDescriptor("RR0120", "roslynator_refactoring.convert_conditional_expression_to_if_else.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertDoToWhile = new RefactoringDescriptor("RR0123", "roslynator_refactoring.convert_do_to_while.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertExpressionBodyToBlockBody = new RefactoringDescriptor("RR0037", "roslynator_refactoring.convert_expression_body_to_block_body.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertForEachToFor = new RefactoringDescriptor("RR0129", "roslynator_refactoring.convert_foreach_to_for.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertForEachToForAndReverseLoop = new RefactoringDescriptor("RR0188", "roslynator_refactoring.convert_foreach_to_for_and_reverse_loop.enabled", isEnabledByDefault: false);
        public static RefactoringDescriptor ConvertForToForEach = new RefactoringDescriptor("RR0130", "roslynator_refactoring.convert_for_to_foreach.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertForToWhile = new RefactoringDescriptor("RR0131", "roslynator_refactoring.convert_for_to_while.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertHasFlagCallToBitwiseOperation = new RefactoringDescriptor("RR0164", "roslynator_refactoring.convert_hasflag_call_to_bitwise_operation.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertHexadecimalLiteralToDecimalLiteral = new RefactoringDescriptor("RR0132", "roslynator_refactoring.convert_hexadecimal_literal_to_decimal_literal.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertIfToConditionalExpression = new RefactoringDescriptor("RR0166", "roslynator_refactoring.convert_if_to_conditional_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertIfToSwitch = new RefactoringDescriptor("RR0133", "roslynator_refactoring.convert_if_to_switch.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertInterpolatedStringToConcatenation = new RefactoringDescriptor("RR0193", "roslynator_refactoring.convert_interpolated_string_to_concatenation.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertInterpolatedStringToStringFormat = new RefactoringDescriptor("RR0201", "roslynator_refactoring.convert_interpolated_string_to_string_format.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertInterpolatedStringToStringLiteral = new RefactoringDescriptor("RR0136", "roslynator_refactoring.convert_interpolated_string_to_string_literal.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertLambdaBlockBodyToExpressionBody = new RefactoringDescriptor("RR0154", "roslynator_refactoring.convert_lambda_block_body_to_expression_body.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertLambdaExpressionBodyToBlockBody = new RefactoringDescriptor("RR0039", "roslynator_refactoring.convert_lambda_expression_body_to_block_body.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertMethodGroupToLambda = new RefactoringDescriptor("RR0137", "roslynator_refactoring.convert_method_group_to_lambda.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertRegularStringLiteralToVerbatimStringLiteral = new RefactoringDescriptor("RR0142", "roslynator_refactoring.convert_regular_string_literal_to_verbatim_string_literal.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertReturnStatementToIf = new RefactoringDescriptor("RR0143", "roslynator_refactoring.convert_return_statement_to_if.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertStatementsToIfElse = new RefactoringDescriptor("RR0211", "roslynator_refactoring.convert_statements_to_if_else.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertStringFormatToInterpolatedString = new RefactoringDescriptor("RR0145", "roslynator_refactoring.convert_string_format_to_interpolated_string.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertSwitchExpressionToSwitchStatement = new RefactoringDescriptor("RR0214", "roslynator_refactoring.convert_switch_expression_to_switch_statement.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertSwitchToIf = new RefactoringDescriptor("RR0147", "roslynator_refactoring.convert_switch_to_if.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertVerbatimStringLiteralToRegularStringLiteral = new RefactoringDescriptor("RR0148", "roslynator_refactoring.convert_verbatim_string_literal_to_regular_string_literal.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertVerbatimStringLiteralToRegularStringLiterals = new RefactoringDescriptor("RR0149", "roslynator_refactoring.convert_verbatim_string_literal_to_regular_string_literals.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertWhileToDo = new RefactoringDescriptor("RR0150", "roslynator_refactoring.convert_while_to_do.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ConvertWhileToFor = new RefactoringDescriptor("RR0151", "roslynator_refactoring.convert_while_to_for.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CopyArgument = new RefactoringDescriptor("RR0030", "roslynator_refactoring.copy_argument.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CopyDocumentationCommentFromBaseMember = new RefactoringDescriptor("RR0029", "roslynator_refactoring.copy_documentation_comment_from_base_member.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CopyMemberDeclaration = new RefactoringDescriptor("RR0031", "roslynator_refactoring.copy_member_declaration.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CopyParameter = new RefactoringDescriptor("RR0032", "roslynator_refactoring.copy_parameter.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CopyStatement = new RefactoringDescriptor("RR0033", "roslynator_refactoring.copy_statement.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor CopySwitchSection = new RefactoringDescriptor("RR0212", "roslynator_refactoring.copy_switch_section.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor DeconstructForeachVariable = new RefactoringDescriptor("RR0217", "roslynator_refactoring.deconstruct_foreach_variable.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ExpandCoalesceExpression = new RefactoringDescriptor("RR0035", "roslynator_refactoring.expand_coalesce_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ExpandCompoundAssignment = new RefactoringDescriptor("RR0034", "roslynator_refactoring.expand_compound_assignment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ExpandEventDeclaration = new RefactoringDescriptor("RR0036", "roslynator_refactoring.expand_event_declaration.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ExpandInitializer = new RefactoringDescriptor("RR0038", "roslynator_refactoring.expand_initializer.enabled", isEnabledByDefault: false);
        public static RefactoringDescriptor ExpandPositionalConstructor = new RefactoringDescriptor("RR0215", "roslynator_refactoring.expand_positional_constructor.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ExtractEventHandlerMethod = new RefactoringDescriptor("RR0203", "roslynator_refactoring.extract_event_handler_method.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ExtractExpressionFromCondition = new RefactoringDescriptor("RR0043", "roslynator_refactoring.extract_expression_from_condition.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ExtractTypeDeclarationToNewFile = new RefactoringDescriptor("RR0046", "roslynator_refactoring.extract_type_declaration_to_new_file.enabled", isEnabledByDefault: false);
        public static RefactoringDescriptor GenerateBaseConstructors = new RefactoringDescriptor("RR0054", "roslynator_refactoring.generate_base_constructors.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor GenerateCombinedEnumMember = new RefactoringDescriptor("RR0055", "roslynator_refactoring.generate_combined_enum_member.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor GenerateEnumMember = new RefactoringDescriptor("RR0056", "roslynator_refactoring.generate_enum_member.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor GenerateEnumValues = new RefactoringDescriptor("RR0057", "roslynator_refactoring.generate_enum_values.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor GenerateEventInvokingMethod = new RefactoringDescriptor("RR0058", "roslynator_refactoring.generate_event_invoking_method.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor GeneratePropertyForDebuggerDisplayAttribute = new RefactoringDescriptor("RR0204", "roslynator_refactoring.generate_property_for_debuggerdisplay_attribute.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ImplementCustomEnumerator = new RefactoringDescriptor("RR0210", "roslynator_refactoring.implement_custom_enumerator.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ImplementIEquatableOfT = new RefactoringDescriptor("RR0179", "roslynator_refactoring.implement_iequatable.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InitializeFieldFromConstructor = new RefactoringDescriptor("RR0197", "roslynator_refactoring.initialize_field_from_constructor.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InitializeLocalVariableWithDefaultValue = new RefactoringDescriptor("RR0060", "roslynator_refactoring.initialize_local_variable_with_default_value.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InlineAliasExpression = new RefactoringDescriptor("RR0061", "roslynator_refactoring.inline_alias_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InlineConstantDeclaration = new RefactoringDescriptor("RR0181", "roslynator_refactoring.inline_constant.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InlineConstantValue = new RefactoringDescriptor("RR0127", "roslynator_refactoring.inline_constant_value.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InlineMethod = new RefactoringDescriptor("RR0062", "roslynator_refactoring.inline_method.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InlineProperty = new RefactoringDescriptor("RR0198", "roslynator_refactoring.inline_property.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InlineUsingStaticDirective = new RefactoringDescriptor("RR0180", "roslynator_refactoring.inline_using_static.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InsertStringInterpolation = new RefactoringDescriptor("RR0063", "roslynator_refactoring.insert_string_interpolation.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor IntroduceAndInitializeField = new RefactoringDescriptor("RR0064", "roslynator_refactoring.introduce_and_initialize_field.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor IntroduceAndInitializeProperty = new RefactoringDescriptor("RR0065", "roslynator_refactoring.introduce_and_initialize_property.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor IntroduceConstructor = new RefactoringDescriptor("RR0066", "roslynator_refactoring.introduce_constructor.enabled", isEnabledByDefault: false);
        public static RefactoringDescriptor IntroduceFieldToLockOn = new RefactoringDescriptor("RR0067", "roslynator_refactoring.introduce_field_to_lock_on.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor IntroduceLocalVariable = new RefactoringDescriptor("RR0068", "roslynator_refactoring.introduce_local_variable.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertBinaryExpression = new RefactoringDescriptor("RR0079", "roslynator_refactoring.invert_binary_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertBooleanLiteral = new RefactoringDescriptor("RR0080", "roslynator_refactoring.invert_boolean_literal.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertConditionalExpression = new RefactoringDescriptor("RR0160", "roslynator_refactoring.invert_conditional_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertIf = new RefactoringDescriptor("RR0189", "roslynator_refactoring.invert_if.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertIfElse = new RefactoringDescriptor("RR0162", "roslynator_refactoring.invert_if_else.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertIsExpression = new RefactoringDescriptor("RR0081", "roslynator_refactoring.invert_is_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertLinqMethodCall = new RefactoringDescriptor("RR0116", "roslynator_refactoring.invert_linq_method_call.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertOperator = new RefactoringDescriptor("RR0082", "roslynator_refactoring.invert_operator.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor InvertPrefixOrPostfixUnaryOperator = new RefactoringDescriptor("RR0134", "roslynator_refactoring.invert_prefix_or_postfix_unary_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor JoinStringExpressions = new RefactoringDescriptor("RR0078", "roslynator_refactoring.join_string_expressions.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MakeMemberAbstract = new RefactoringDescriptor("RR0069", "roslynator_refactoring.make_member_abstract.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MakeMemberVirtual = new RefactoringDescriptor("RR0070", "roslynator_refactoring.make_member_virtual.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MergeAttributes = new RefactoringDescriptor("RR0074", "roslynator_refactoring.merge_attributes.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MergeIfStatements = new RefactoringDescriptor("RR0075", "roslynator_refactoring.merge_if_statements.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MergeIfWithParentIf = new RefactoringDescriptor("RR0196", "roslynator_refactoring.merge_if_with_parent_if.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MergeLocalDeclarations = new RefactoringDescriptor("RR0077", "roslynator_refactoring.merge_local_declarations.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MergeSwitchSections = new RefactoringDescriptor("RR0110", "roslynator_refactoring.merge_switch_sections.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor MoveUnsafeContextToContainingDeclaration = new RefactoringDescriptor("RR0202", "roslynator_refactoring.move_unsafe_context_to_containing_declaration.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor NotifyWhenPropertyChanges = new RefactoringDescriptor("RR0083", "roslynator_refactoring.notify_when_property_changes.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ParenthesizeExpression = new RefactoringDescriptor("RR0084", "roslynator_refactoring.parenthesize_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor PromoteLocalVariableToParameter = new RefactoringDescriptor("RR0085", "roslynator_refactoring.promote_local_variable_to_parameter.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAllComments = new RefactoringDescriptor("RR0086", "roslynator_refactoring.remove_all_comments.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAllCommentsExceptDocumentationComments = new RefactoringDescriptor("RR0087", "roslynator_refactoring.remove_all_comments_except_documentation_comments.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAllDocumentationComments = new RefactoringDescriptor("RR0088", "roslynator_refactoring.remove_all_documentation_comments.enabled", isEnabledByDefault: false);
        public static RefactoringDescriptor RemoveAllMemberDeclarations = new RefactoringDescriptor("RR0089", "roslynator_refactoring.remove_all_member_declarations.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAllPreprocessorDirectives = new RefactoringDescriptor("RR0090", "roslynator_refactoring.remove_all_preprocessor_directives.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAllRegionDirectives = new RefactoringDescriptor("RR0091", "roslynator_refactoring.remove_all_region_directives.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAllStatements = new RefactoringDescriptor("RR0092", "roslynator_refactoring.remove_all_statements.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAllSwitchSections = new RefactoringDescriptor("RR0093", "roslynator_refactoring.remove_all_switch_sections.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveArgumentName = new RefactoringDescriptor("RR0105", "roslynator_refactoring.remove_argument_name.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveAsyncAwait = new RefactoringDescriptor("RR0209", "roslynator_refactoring.remove_async_await.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveBraces = new RefactoringDescriptor("RR0094", "roslynator_refactoring.remove_braces.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveBracesFromIfElse = new RefactoringDescriptor("RR0095", "roslynator_refactoring.remove_braces_from_if_else.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveBracesFromSwitchSection = new RefactoringDescriptor("RR0096", "roslynator_refactoring.remove_braces_from_switch_section.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveBracesFromSwitchSections = new RefactoringDescriptor("RR0097", "roslynator_refactoring.remove_braces_from_switch_sections.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveComment = new RefactoringDescriptor("RR0098", "roslynator_refactoring.remove_comment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveConditionFromLastElse = new RefactoringDescriptor("RR0099", "roslynator_refactoring.remove_condition_from_last_else.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveContainingStatement = new RefactoringDescriptor("RR0045", "roslynator_refactoring.remove_containing_statement.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveEmptyLines = new RefactoringDescriptor("RR0101", "roslynator_refactoring.remove_empty_lines.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveEnumMemberValue = new RefactoringDescriptor("RR0199", "roslynator_refactoring.remove_enum_member_value.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveInstantiationOfLocalVariable = new RefactoringDescriptor("RR0185", "roslynator_refactoring.remove_instantiation_of_local_variable.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveInterpolation = new RefactoringDescriptor("RR0102", "roslynator_refactoring.remove_interpolation.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveMemberDeclaration = new RefactoringDescriptor("RR0103", "roslynator_refactoring.remove_member_declaration.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveMemberDeclarations = new RefactoringDescriptor("RR0104", "roslynator_refactoring.remove_member_declarations_above_or_below.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveParentheses = new RefactoringDescriptor("RR0106", "roslynator_refactoring.remove_parentheses.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemovePreprocessorDirective = new RefactoringDescriptor("RR0100", "roslynator_refactoring.remove_preprocessor_directive.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemovePropertyInitializer = new RefactoringDescriptor("RR0107", "roslynator_refactoring.remove_property_initializer.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveRegion = new RefactoringDescriptor("RR0108", "roslynator_refactoring.remove_region.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveStatement = new RefactoringDescriptor("RR0109", "roslynator_refactoring.remove_statement.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RemoveUnnecessaryAssignment = new RefactoringDescriptor("RR0073", "roslynator_refactoring.remove_unnecessary_assignment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RenameIdentifierAccordingToTypeName = new RefactoringDescriptor("RR0112", "roslynator_refactoring.rename_identifier_according_to_type_name.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RenameMethodAccordingToTypeName = new RefactoringDescriptor("RR0113", "roslynator_refactoring.rename_method_according_to_type_name.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RenameParameterAccordingToTypeName = new RefactoringDescriptor("RR0114", "roslynator_refactoring.rename_parameter_according_to_type_name.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor RenamePropertyAccordingToTypeName = new RefactoringDescriptor("RR0115", "roslynator_refactoring.rename_property_according_to_type_name.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceAsExpressionWithExplicitCast = new RefactoringDescriptor("RR0117", "roslynator_refactoring.replace_as_expression_with_explicit_cast.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceConditionalExpressionWithTrueOrFalseBranch = new RefactoringDescriptor("RR0119", "roslynator_refactoring.replace_conditional_expression_with_true_or_false_branch.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceEqualityOperatorWithStringEquals = new RefactoringDescriptor("RR0124", "roslynator_refactoring.replace_equality_operator_with_string_equals.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceEqualityOperatorWithStringIsNullOrEmpty = new RefactoringDescriptor("RR0125", "roslynator_refactoring.replace_equality_operator_with_string_isnullorempty.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceEqualityOperatorWithStringIsNullOrWhiteSpace = new RefactoringDescriptor("RR0126", "roslynator_refactoring.replace_equality_operator_with_string_isnullorwhitespace.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceExplicitCastWithAsExpression = new RefactoringDescriptor("RR0118", "roslynator_refactoring.replace_explicit_cast_with_as_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceInterpolatedStringWithInterpolationExpression = new RefactoringDescriptor("RR0135", "roslynator_refactoring.replace_interpolated_string_with_interpolation_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplaceMethodWithProperty = new RefactoringDescriptor("RR0138", "roslynator_refactoring.replace_method_with_property.enabled", isEnabledByDefault: false);
        public static RefactoringDescriptor ReplaceNullLiteralWithDefaultExpression = new RefactoringDescriptor("RR0139", "roslynator_refactoring.replace_null_literal_with_default_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplacePrefixOperatorWithPostfixOperator = new RefactoringDescriptor("RR0140", "roslynator_refactoring.replace_prefix_operator_with_postfix_operator.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReplacePropertyWithMethod = new RefactoringDescriptor("RR0141", "roslynator_refactoring.replace_property_with_method.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor ReverseForStatement = new RefactoringDescriptor("RR0152", "roslynator_refactoring.reverse_for_statement.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SimplifyIf = new RefactoringDescriptor("RR0153", "roslynator_refactoring.simplify_if.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SortCaseLabels = new RefactoringDescriptor("RR0207", "roslynator_refactoring.sort_case_labels.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SortMemberDeclarations = new RefactoringDescriptor("RR0155", "roslynator_refactoring.sort_member_declarations.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SplitAttributes = new RefactoringDescriptor("RR0156", "roslynator_refactoring.split_attributes.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SplitIf = new RefactoringDescriptor("RR0184", "roslynator_refactoring.split_if.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SplitIfElse = new RefactoringDescriptor("RR0190", "roslynator_refactoring.split_if_else.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SplitLocalDeclarationAndAssignment = new RefactoringDescriptor("RR0194", "roslynator_refactoring.split_local_declaration_and_assignment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SplitSwitchLabels = new RefactoringDescriptor("RR0157", "roslynator_refactoring.split_switch_labels.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SplitVariableDeclaration = new RefactoringDescriptor("RR0158", "roslynator_refactoring.split_variable_declaration.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SwapBinaryOperands = new RefactoringDescriptor("RR0159", "roslynator_refactoring.swap_binary_operands.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SwapMemberDeclarations = new RefactoringDescriptor("RR0161", "roslynator_refactoring.swap_member_declarations.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor SyncPropertyNameAndBackingFieldName = new RefactoringDescriptor("RR0111", "roslynator_refactoring.sync_property_name_and_backing_field_name.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UncommentMultiLineComment = new RefactoringDescriptor("RR0200", "roslynator_refactoring.uncomment_multiline_comment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UncommentSingleLineComment = new RefactoringDescriptor("RR0163", "roslynator_refactoring.uncomment_singleline_comment.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseCoalesceExpressionInsteadOfIf = new RefactoringDescriptor("RR0165", "roslynator_refactoring.use_coalesce_expression_instead_of_if.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseConstantInsteadOfReadOnlyField = new RefactoringDescriptor("RR0128", "roslynator_refactoring.use_constant_instead_of_readonly_field.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseElementAccessInsteadOfLinqMethod = new RefactoringDescriptor("RR0167", "roslynator_refactoring.use_element_access_instead_of_linq_method.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseEnumeratorExplicitly = new RefactoringDescriptor("RR0206", "roslynator_refactoring.use_enumerator_explicitly.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseExplicitType = new RefactoringDescriptor("RR0023", "roslynator_refactoring.use_explicit_type.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseImplicitType = new RefactoringDescriptor("RR0018", "roslynator_refactoring.use_implicit_type.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseIndexInitializer = new RefactoringDescriptor("RR0191", "roslynator_refactoring.use_index_initializer.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseLambdaInsteadOfAnonymousMethod = new RefactoringDescriptor("RR0170", "roslynator_refactoring.use_lambda_instead_of_anonymous_method.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseListInsteadOfYield = new RefactoringDescriptor("RR0183", "roslynator_refactoring.use_list_instead_of_yield.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseObjectInitializer = new RefactoringDescriptor("RR0026", "roslynator_refactoring.use_object_initializer.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseReadOnlyFieldInsteadOfConstant = new RefactoringDescriptor("RR0121", "roslynator_refactoring.use_readonly_field_instead_of_constant.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseStringBuilderInsteadOfConcatenation = new RefactoringDescriptor("RR0182", "roslynator_refactoring.use_stringbuilder_instead_of_concatenation.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor UseStringEmptyInsteadOfEmptyStringLiteral = new RefactoringDescriptor("RR0171", "roslynator_refactoring.use_string_empty_instead_of_empty_string_literal.enabled", isEnabledByDefault: false);
        public static RefactoringDescriptor WrapArguments = new RefactoringDescriptor("RR0048", "roslynator_refactoring.wrap_arguments.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapBinaryExpression = new RefactoringDescriptor("RR0049", "roslynator_refactoring.wrap_binary_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapCallChain = new RefactoringDescriptor("RR0051", "roslynator_refactoring.wrap_call_chain.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapConditionalExpression = new RefactoringDescriptor("RR0050", "roslynator_refactoring.wrap_conditional_expression.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapConstraintClauses = new RefactoringDescriptor("RR0187", "roslynator_refactoring.wrap_constraint_clauses.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapInitializerExpressions = new RefactoringDescriptor("RR0052", "roslynator_refactoring.wrap_initializer_expressions.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapLinesInPreprocessorDirective = new RefactoringDescriptor("RR0174", "roslynator_refactoring.wrap_lines_in_preprocessor_directive.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapLinesInRegion = new RefactoringDescriptor("RR0175", "roslynator_refactoring.wrap_lines_in_region.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapLinesInTryCatch = new RefactoringDescriptor("RR0176", "roslynator_refactoring.wrap_lines_in_try_catch.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapParameters = new RefactoringDescriptor("RR0053", "roslynator_refactoring.wrap_parameters.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapStatementsInCondition = new RefactoringDescriptor("RR0172", "roslynator_refactoring.wrap_statements_in_condition.enabled", isEnabledByDefault: true);
        public static RefactoringDescriptor WrapStatementsInUsingStatement = new RefactoringDescriptor("RR0177", "roslynator_refactoring.wrap_statements_in_using_statement.enabled", isEnabledByDefault: true);
    }
}