﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Immutable;
using Microsoft.CodeAnalysis;

namespace Roslynator;

internal readonly struct DocumentReferenceInfo
{
    public DocumentReferenceInfo(Document document, SyntaxNode root, ImmutableArray<SyntaxNode> references)
    {
        Document = document;
        Root = root;
        References = references;
    }

    public Document Document { get; }

    public SyntaxNode Root { get; }

    public ImmutableArray<SyntaxNode> References { get; }
}
