﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Immutable;
using Microsoft.CodeAnalysis.CSharp;
using Microsoft.CodeAnalysis.CSharp.Syntax;
using static Microsoft.CodeAnalysis.CSharp.SyntaxFactory;
using static Roslynator.CSharp.CSharpFactory;

namespace Roslynator.CSharp.Refactorings.WrapStatements;

internal sealed class WrapInIfStatementRefactoring : WrapStatementsRefactoring<IfStatementSyntax>
{
    private WrapInIfStatementRefactoring()
    {
    }

    public static WrapInIfStatementRefactoring Instance { get; } = new();

    public const string Title = "'if' statement";

    public override IfStatementSyntax CreateStatement(ImmutableArray<StatementSyntax> statements)
    {
        return IfStatement(
            Token(SyntaxKind.IfKeyword),
            OpenParenToken(),
            ParseExpression(""),
            CloseParenToken().WithNavigationAnnotation(),
            Block(statements),
            default(ElseClauseSyntax));
    }
}
