﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;
using System.Diagnostics;
using Microsoft.CodeAnalysis;

namespace Roslynator.CSharp.Refactorings;

internal static class UncommentMultiLineCommentRefactoring
{
    public static void ComputeRefactoring(
        RefactoringContext context,
        SyntaxTrivia multiLineComment)
    {
        string s = multiLineComment.ToString();

        Debug.Assert(s.StartsWith("/*", StringComparison.Ordinal));
        Debug.Assert(s.EndsWith("*/", StringComparison.Ordinal));

        if (!s.StartsWith("/*", StringComparison.Ordinal))
            return;

        if (!s.EndsWith("*/", StringComparison.Ordinal))
            return;

        context.RegisterRefactoring(
            "Uncomment",
            ct => context.Document.WithTextChangeAsync(multiLineComment.Span, s.Substring(2, s.Length - 4), ct),
            RefactoringDescriptors.UncommentMultiLineComment);
    }
}
