﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using Microsoft.CodeAnalysis;
using Microsoft.CodeAnalysis.CSharp.Syntax;

namespace Roslynator.CSharp.Analysis.If;

internal abstract class ToAssignmentWithConditionalExpressionAnalysis : IfAnalysis
{
    protected ToAssignmentWithConditionalExpressionAnalysis(
        IfStatementSyntax ifStatement,
        ExpressionSyntax whenTrue,
        ExpressionSyntax whenFalse,
        SemanticModel semanticModel) : base(ifStatement, semanticModel)
    {
        WhenTrue = whenTrue;
        WhenFalse = whenFalse;
    }

    public override string Title
    {
        get { return "Convert 'if' to ?:"; }
    }

    public ExpressionSyntax WhenTrue { get; }

    public ExpressionSyntax WhenFalse { get; }
}
