﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// <auto-generated>

using Roslynator.CodeFixes;

namespace Roslynator.CSharp
{
    public static partial class CodeFixDescriptors
    {
        /// <summary>RCF0002 (fixes CS0163, CS8070)</summary>
        public static readonly CodeFixDescriptor AddBreakStatementToSwitchSection = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddBreakStatementToSwitchSection, 
            title:              "Add break statement to switch section", 
            isEnabledByDefault: true, 
            "CS0163", 
            "CS8070");

        /// <summary>RCF0003 (fixes CS0266)</summary>
        public static readonly CodeFixDescriptor CreateSingletonArray = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.CreateSingletonArray, 
            title:              "Create singleton array", 
            isEnabledByDefault: true, 
            "CS0266");

        /// <summary>RCF0004 (fixes CS1620)</summary>
        public static readonly CodeFixDescriptor AddOutModifierToArgument = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddOutModifierToArgument, 
            title:              "Add 'out' modifier to argument", 
            isEnabledByDefault: true, 
            "CS1620");

        /// <summary>RCF0005 (fixes CS1722)</summary>
        public static readonly CodeFixDescriptor MoveBaseClassBeforeAnyInterface = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MoveBaseClassBeforeAnyInterface, 
            title:              "Base base class before any interface", 
            isEnabledByDefault: true, 
            "CS1722");

        /// <summary>RCF0006 (fixes CS0114)</summary>
        public static readonly CodeFixDescriptor AddOverrideModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddOverrideModifier, 
            title:              "Add 'override' modifier", 
            isEnabledByDefault: true, 
            "CS0114");

        /// <summary>RCF0007 (fixes CS0114)</summary>
        public static readonly CodeFixDescriptor AddNewModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddNewModifier, 
            title:              "Add 'new' modifier", 
            isEnabledByDefault: true, 
            "CS0114");

        /// <summary>RCF0008 (fixes CS1674)</summary>
        public static readonly CodeFixDescriptor ExtractDeclarationFromUsingStatement = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ExtractDeclarationFromUsingStatement, 
            title:              "Extract declaration from using statement", 
            isEnabledByDefault: true, 
            "CS1674");

        /// <summary>RCF0009 (fixes CS1023)</summary>
        public static readonly CodeFixDescriptor AddBracesToDeclarationOrLabeledStatement = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddBracesToDeclarationOrLabeledStatement, 
            title:              "Add braces to declaration or labeled statement", 
            isEnabledByDefault: true, 
            "CS1023");

        /// <summary>RCF0010 (fixes CS0558)</summary>
        public static readonly CodeFixDescriptor MarkOperatorAsPublicAndStatic = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MarkOperatorAsPublicAndStatic, 
            title:              "Mark operator as 'public' and 'static'", 
            isEnabledByDefault: true, 
            "CS0558");

        /// <summary>RCF0011 (fixes CS1004)</summary>
        public static readonly CodeFixDescriptor RemoveDuplicateModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveDuplicateModifier, 
            title:              "Remove duplicate modifier", 
            isEnabledByDefault: true, 
            "CS1004");

        /// <summary>RCF0012 (fixes CS0579)</summary>
        public static readonly CodeFixDescriptor RemoveDuplicateAttribute = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveDuplicateAttribute, 
            title:              "Remove duplicate attribute", 
            isEnabledByDefault: true, 
            "CS0579");

        /// <summary>RCF0013 (fixes CS0109)</summary>
        public static readonly CodeFixDescriptor RemoveNewModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveNewModifier, 
            title:              "Remove new modifier", 
            isEnabledByDefault: true, 
            "CS0109");

        /// <summary>RCF0014 (fixes CS0164)</summary>
        public static readonly CodeFixDescriptor RemoveUnusedLabel = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveUnusedLabel, 
            title:              "Remove unused label", 
            isEnabledByDefault: true, 
            "CS0164");

        /// <summary>RCF0016 (fixes CS1591)</summary>
        public static readonly CodeFixDescriptor AddDocumentationComment = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddDocumentationComment, 
            title:              "Add documentation comment", 
            isEnabledByDefault: true, 
            "CS1591");

        /// <summary>RCF0017 (fixes CS0162)</summary>
        public static readonly CodeFixDescriptor RemoveUnreachableCode = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveUnreachableCode, 
            title:              "Unreachable code detected", 
            isEnabledByDefault: true, 
            "CS0162");

        /// <summary>RCF0018 (fixes CS0508, CS0766, CS1624, CS1983)</summary>
        public static readonly CodeFixDescriptor ChangeMethodReturnType = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeMethodReturnType, 
            title:              "Change method return type", 
            isEnabledByDefault: true, 
            "CS0508", 
            "CS0766", 
            "CS1624", 
            "CS1983");

        /// <summary>RCF0019 (fixes CS1715)</summary>
        public static readonly CodeFixDescriptor MemberTypeMustMatchOverriddenMemberType = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MemberTypeMustMatchOverriddenMemberType, 
            title:              "Member type must match overridden member type", 
            isEnabledByDefault: true, 
            "CS1715");

        /// <summary>RCF0020 (fixes CS0161, CS1643)</summary>
        public static readonly CodeFixDescriptor AddReturnStatementThatReturnsDefaultValue = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddReturnStatementThatReturnsDefaultValue, 
            title:              "Add return statement that returns default value", 
            isEnabledByDefault: true, 
            "CS0161", 
            "CS1643");

        /// <summary>RCF0021 (fixes CS0029, CS1622)</summary>
        public static readonly CodeFixDescriptor UseYieldReturnInsteadOfReturn = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.UseYieldReturnInsteadOfReturn, 
            title:              "Use yield return instead of return", 
            isEnabledByDefault: true, 
            "CS0029", 
            "CS1622");

        /// <summary>RCF0022 (fixes CS0029)</summary>
        public static readonly CodeFixDescriptor ReplaceStringLiteralWithCharacterLiteral = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceStringLiteralWithCharacterLiteral, 
            title:              "Replace string literal with character literal", 
            isEnabledByDefault: true, 
            "CS0029");

        /// <summary>RCF0023 (fixes CS0019, CS0266)</summary>
        public static readonly CodeFixDescriptor AddComparisonWithBooleanLiteral = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddComparisonWithBooleanLiteral, 
            title:              "Add comparison with boolean literal", 
            isEnabledByDefault: true, 
            "CS0019", 
            "CS0266");

        /// <summary>RCF0024 (fixes CS0037, CS0573, CS8050)</summary>
        public static readonly CodeFixDescriptor RemovePropertyOrFieldInitializer = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemovePropertyOrFieldInitializer, 
            title:              "Remove property or field initializer", 
            isEnabledByDefault: true, 
            "CS0037", 
            "CS0573", 
            "CS8050");

        /// <summary>RCF0025 (fixes CS0101, CS0102, CS0260, CS0751)</summary>
        public static readonly CodeFixDescriptor AddPartialModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddPartialModifier, 
            title:              "Add 'partial' modifier", 
            isEnabledByDefault: true, 
            "CS0101", 
            "CS0102", 
            "CS0260", 
            "CS0751");

        /// <summary>RCF0026 (fixes CS0501, CS0756, CS8112)</summary>
        public static readonly CodeFixDescriptor AddBody = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddBody, 
            title:              "Add body", 
            isEnabledByDefault: true, 
            "CS0501", 
            "CS0756", 
            "CS8112");

        /// <summary>RCF0027 (fixes CS0192, CS1615, CS1623, CS1988)</summary>
        public static readonly CodeFixDescriptor RemoveRefModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveRefModifier, 
            title:              "Remove 'ref' modifier", 
            isEnabledByDefault: true, 
            "CS0192", 
            "CS1615", 
            "CS1623", 
            "CS1988");

        /// <summary>RCF0028 (fixes CS1717)</summary>
        public static readonly CodeFixDescriptor RemoveRedundantAssignment = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveRedundantAssignment, 
            title:              "Remove redundant assignment", 
            isEnabledByDefault: true, 
            "CS1717");

        /// <summary>RCF0029 (fixes CS0442, CS0507, CS0621, CS0628, CS1057, CS1527)</summary>
        public static readonly CodeFixDescriptor ChangeAccessibility = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeAccessibility, 
            title:              "Change accessibility", 
            isEnabledByDefault: true, 
            "CS0442", 
            "CS0507", 
            "CS0621", 
            "CS0628", 
            "CS1057", 
            "CS1527");

        /// <summary>RCF0030 (fixes CS0225)</summary>
        public static readonly CodeFixDescriptor ChangeTypeOfParamsParameter = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeTypeOfParamsParameter, 
            title:              "Change type of 'params' parameter", 
            isEnabledByDefault: true, 
            "CS0225");

        /// <summary>RCF0031 (fixes CS0221)</summary>
        public static readonly CodeFixDescriptor UseUncheckedExpression = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.UseUncheckedExpression, 
            title:              "Use unchecked expression", 
            isEnabledByDefault: true, 
            "CS0221");

        /// <summary>RCF0032 (fixes CS0069, CS0500, CS0531)</summary>
        public static readonly CodeFixDescriptor RemoveImplementationFromAbstractMember = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveImplementationFromAbstractMember, 
            title:              "Remove implementation from abstract member", 
            isEnabledByDefault: true, 
            "CS0069", 
            "CS0500", 
            "CS0531");

        /// <summary>RCF0033 (fixes CS0708, CS0710, CS1105, CS1106)</summary>
        public static readonly CodeFixDescriptor AddStaticModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddStaticModifier, 
            title:              "Add 'static' modifier", 
            isEnabledByDefault: true, 
            "CS0708", 
            "CS0710", 
            "CS1105", 
            "CS1106");

        /// <summary>RCF0034 (fixes CS0513)</summary>
        public static readonly CodeFixDescriptor MakeContainingClassAbstract = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeContainingClassAbstract, 
            title:              "Make containing class abstract", 
            isEnabledByDefault: true, 
            "CS0513");

        /// <summary>RCF0036 (fixes CS0262)</summary>
        public static readonly CodeFixDescriptor SynchronizeAccessibility = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.SynchronizeAccessibility, 
            title:              "Synchronize accessibility", 
            isEnabledByDefault: true, 
            "CS0262");

        /// <summary>RCF0037 (fixes CS1955)</summary>
        public static readonly CodeFixDescriptor RemoveArgumentList = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveArgumentList, 
            title:              "Remove argument list", 
            isEnabledByDefault: true, 
            "CS1955");

        /// <summary>RCF0038 (fixes CS1061)</summary>
        public static readonly CodeFixDescriptor FixMemberAccessName = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.FixMemberAccessName, 
            title:              "Fix member access name", 
            isEnabledByDefault: true, 
            "CS1061");

        /// <summary>RCF0039 (fixes CS0023, CS0119, CS0201, CS0428, CS1526)</summary>
        public static readonly CodeFixDescriptor AddArgumentList = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddArgumentList, 
            title:              "Add argument list", 
            isEnabledByDefault: true, 
            "CS0023", 
            "CS0119", 
            "CS0201", 
            "CS0428", 
            "CS1526");

        /// <summary>RCF0040 (fixes CS0165)</summary>
        public static readonly CodeFixDescriptor InitializeLocalVariableWithDefaultValue = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.InitializeLocalVariableWithDefaultValue, 
            title:              "Initialize local variable with default value", 
            isEnabledByDefault: true, 
            "CS0165");

        /// <summary>RCF0041 (fixes CS0123, CS0407, CS0815)</summary>
        public static readonly CodeFixDescriptor ChangeTypeOfLocalVariable = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeTypeOfLocalVariable, 
            title:              "Change type of local variable", 
            isEnabledByDefault: true, 
            "CS0123", 
            "CS0407", 
            "CS0815");

        /// <summary>RCF0042 (fixes CS0120)</summary>
        public static readonly CodeFixDescriptor MakeMemberNonStatic = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeMemberNonStatic, 
            title:              "Make member non-static", 
            isEnabledByDefault: true, 
            "CS0120");

        /// <summary>RCF0043 (fixes CS0080)</summary>
        public static readonly CodeFixDescriptor RemoveConstraintClauses = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveConstraintClauses, 
            title:              "Remove constraint clauses", 
            isEnabledByDefault: true, 
            "CS0080");

        /// <summary>RCF0044 (fixes CS0305)</summary>
        public static readonly CodeFixDescriptor AddTypeArgument = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddTypeArgument, 
            title:              "Add type argument", 
            isEnabledByDefault: true, 
            "CS0305");

        /// <summary>RCF0045 (fixes CS0131, CS0133)</summary>
        public static readonly CodeFixDescriptor RemoveConstModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveConstModifier, 
            title:              "Remove 'const' modifier", 
            isEnabledByDefault: true, 
            "CS0131", 
            "CS0133");

        /// <summary>RCF0046 (fixes CS1522)</summary>
        public static readonly CodeFixDescriptor RemoveEmptySwitchStatement = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveEmptySwitchStatement, 
            title:              "Remove empty switch statement", 
            isEnabledByDefault: true, 
            "CS1522");

        /// <summary>RCF0047 (fixes CS0201)</summary>
        public static readonly CodeFixDescriptor IntroduceLocalVariable = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.IntroduceLocalVariable, 
            title:              "Introduce local variable", 
            isEnabledByDefault: true, 
            "CS0201");

        /// <summary>RCF0048 (fixes CS0214, CS0819, CS0822)</summary>
        public static readonly CodeFixDescriptor UseExplicitTypeInsteadOfVar = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.UseExplicitTypeInsteadOfVar, 
            title:              "Use explicit type instead of 'var'", 
            isEnabledByDefault: true, 
            "CS0214", 
            "CS0819", 
            "CS0822");

        /// <summary>RCF0049 (fixes CS1061)</summary>
        public static readonly CodeFixDescriptor RemoveAwaitKeyword = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveAwaitKeyword, 
            title:              "Remove 'await' keyword", 
            isEnabledByDefault: true, 
            "CS1061");

        /// <summary>RCF0050 (fixes CS0214)</summary>
        public static readonly CodeFixDescriptor WrapInUnsafeStatement = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.WrapInUnsafeStatement, 
            title:              "Wrap in unsafe statement", 
            isEnabledByDefault: true, 
            "CS0214");

        /// <summary>RCF0051 (fixes CS0214)</summary>
        public static readonly CodeFixDescriptor MakeContainingDeclarationUnsafe = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeContainingDeclarationUnsafe, 
            title:              "Make containing declaration unsafe", 
            isEnabledByDefault: true, 
            "CS0214");

        /// <summary>RCF0053 (fixes CS0132)</summary>
        public static readonly CodeFixDescriptor RemoveParametersFromStaticConstructor = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveParametersFromStaticConstructor, 
            title:              "Remove parameters from static constructor", 
            isEnabledByDefault: true, 
            "CS0132");

        /// <summary>RCF0054 (fixes CS0267)</summary>
        public static readonly CodeFixDescriptor OrderModifiers = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.OrderModifiers, 
            title:              "Order modifiers", 
            isEnabledByDefault: true, 
            "CS0267");

        /// <summary>RCF0055 (fixes CS0107, CS0112, CS0115, CS0275, CS0441, CS0515, CS0678, CS0750, CS0753, CS0759, CS1609, CS1994)</summary>
        public static readonly CodeFixDescriptor RemoveInvalidModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveInvalidModifier, 
            title:              "Remove invalid modifier", 
            isEnabledByDefault: true, 
            "CS0107", 
            "CS0112", 
            "CS0115", 
            "CS0275", 
            "CS0441", 
            "CS0515", 
            "CS0678", 
            "CS0750", 
            "CS0753", 
            "CS0759", 
            "CS1609", 
            "CS1994");

        /// <summary>RCF0056 (fixes CS0114, CS0525, CS0541, CS0567, CS0568, CS0575)</summary>
        public static readonly CodeFixDescriptor RemoveMemberDeclaration = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveMemberDeclaration, 
            title:              "Remove member declaration", 
            isEnabledByDefault: true, 
            "CS0114", 
            "CS0525", 
            "CS0541", 
            "CS0567", 
            "CS0568", 
            "CS0575");

        /// <summary>RCF0058 (fixes CS0037, CS0403, CS1503, CS1750)</summary>
        public static readonly CodeFixDescriptor ReplaceNullLiteralExpressionWithDefaultValue = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceNullLiteralExpressionWithDefaultValue, 
            title:              "Replace 'null' with default value", 
            isEnabledByDefault: true, 
            "CS0037", 
            "CS0403", 
            "CS1503", 
            "CS1750");

        /// <summary>RCF0059 (fixes CS0128, CS0136)</summary>
        public static readonly CodeFixDescriptor ReplaceVariableDeclarationWithAssignment = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceVariableDeclarationWithAssignment, 
            title:              "Replace variable declaration with assignment", 
            isEnabledByDefault: true, 
            "CS0128", 
            "CS0136");

        /// <summary>RCF0060 (fixes CS1100, CS1105, CS1106)</summary>
        public static readonly CodeFixDescriptor RemoveThisModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveThisModifier, 
            title:              "Remove 'this' modifier", 
            isEnabledByDefault: true, 
            "CS1100", 
            "CS1105", 
            "CS1106");

        /// <summary>RCF0061 (fixes CS0693)</summary>
        public static readonly CodeFixDescriptor RemoveTypeParameter = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveTypeParameter, 
            title:              "Remove type parameter", 
            isEnabledByDefault: true, 
            "CS0693");

        /// <summary>RCF0062 (fixes CS0708, CS0710)</summary>
        public static readonly CodeFixDescriptor MakeContainingClassNonStatic = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeContainingClassNonStatic, 
            title:              "Make containing class non-static", 
            isEnabledByDefault: true, 
            "CS0708", 
            "CS0710");

        /// <summary>RCF0063 (fixes CS0173)</summary>
        public static readonly CodeFixDescriptor AddExplicitCast = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddExplicitCast, 
            title:              "Add explicit cast", 
            isEnabledByDefault: true, 
            "CS0173");

        /// <summary>RCF0064 (fixes CS0401, CS0449)</summary>
        public static readonly CodeFixDescriptor MoveConstraint = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MoveConstraint, 
            title:              "Move constraint", 
            isEnabledByDefault: true, 
            "CS0401", 
            "CS0449");

        /// <summary>RCF0065 (fixes CS0405, CS0450, CS0451, CS0714)</summary>
        public static readonly CodeFixDescriptor RemoveConstraint = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveConstraint, 
            title:              "Remove constraint", 
            isEnabledByDefault: true, 
            "CS0405", 
            "CS0450", 
            "CS0451", 
            "CS0714");

        /// <summary>RCF0066 (fixes CS0409)</summary>
        public static readonly CodeFixDescriptor CombineConstraintClauses = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.CombineConstraintClauses, 
            title:              "Combine constraint clauses", 
            isEnabledByDefault: true, 
            "CS0409");

        /// <summary>RCF0067 (fixes CS0177)</summary>
        public static readonly CodeFixDescriptor AssignDefaultValueToOutParameter = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AssignDefaultValueToOutParameter, 
            title:              "Assign default value to 'out' parameter", 
            isEnabledByDefault: true, 
            "CS0177");

        /// <summary>RCF0068 (fixes CS0713, CS0714, CS0718)</summary>
        public static readonly CodeFixDescriptor MakeClassNonStatic = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeClassNonStatic, 
            title:              "Make class non-static", 
            isEnabledByDefault: true, 
            "CS0713", 
            "CS0714", 
            "CS0718");

        /// <summary>RCF0069 (fixes CS1621)</summary>
        public static readonly CodeFixDescriptor RemoveYieldKeyword = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveYieldKeyword, 
            title:              "Remove 'yield' keyword", 
            isEnabledByDefault: true, 
            "CS1621");

        /// <summary>RCF0070 (fixes CS0192, CS1623, CS1988)</summary>
        public static readonly CodeFixDescriptor RemoveOutModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveOutModifier, 
            title:              "Remove 'out' modifier", 
            isEnabledByDefault: true, 
            "CS0192", 
            "CS1623", 
            "CS1988");

        /// <summary>RCF0071 (fixes CS0592, CS1689)</summary>
        public static readonly CodeFixDescriptor RemoveAttribute = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveAttribute, 
            title:              "Remove attribute", 
            isEnabledByDefault: true, 
            "CS0592", 
            "CS1689");

        /// <summary>RCF0072 (fixes CS0139)</summary>
        public static readonly CodeFixDescriptor RemoveJumpStatement = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveJumpStatement, 
            title:              "Remove jump statement", 
            isEnabledByDefault: true, 
            "CS0139");

        /// <summary>RCF0073 (fixes CS0266)</summary>
        public static readonly CodeFixDescriptor UseCoalesceExpression = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.UseCoalesceExpression, 
            title:              "Use coalesce expression", 
            isEnabledByDefault: true, 
            "CS0266");

        /// <summary>RCF0074 (fixes CS0077)</summary>
        public static readonly CodeFixDescriptor ReplaceAsExpressionWithCastExpression = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceAsExpressionWithCastExpression, 
            title:              "Replace as expression with cast expression", 
            isEnabledByDefault: true, 
            "CS0077");

        /// <summary>RCF0075 (fixes CS0472)</summary>
        public static readonly CodeFixDescriptor RemoveConditionThatIsAlwaysEqualToTrueOrFalse = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveConditionThatIsAlwaysEqualToTrueOrFalse, 
            title:              "Remove condition that is always equal to true/false", 
            isEnabledByDefault: true, 
            "CS0472");

        /// <summary>RCF0076 (fixes CS0201)</summary>
        public static readonly CodeFixDescriptor IntroduceField = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.IntroduceField, 
            title:              "Introduce field", 
            isEnabledByDefault: true, 
            "CS0201");

        /// <summary>RCF0077 (fixes CS0021)</summary>
        public static readonly CodeFixDescriptor UseInvocationInsteadOfIndexer = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.UseInvocationInsteadOfIndexer, 
            title:              "Use invocation instead of indexer", 
            isEnabledByDefault: true, 
            "CS0021");

        /// <summary>RCF0078 (fixes CS0103)</summary>
        public static readonly CodeFixDescriptor AddVariableType = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddVariableType, 
            title:              "Add variable type", 
            isEnabledByDefault: true, 
            "CS0103");

        /// <summary>RCF0079 (fixes CS0139)</summary>
        public static readonly CodeFixDescriptor ReplaceBreakWithContinue = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceBreakWithContinue, 
            title:              "Replace 'break' with 'continue'", 
            isEnabledByDefault: true, 
            "CS0139");

        /// <summary>RCF0080 (fixes CS0029, CS0127, CS0201, CS0246, CS0266, CS1997)</summary>
        public static readonly CodeFixDescriptor ChangeMemberTypeAccordingToReturnExpression = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeMemberTypeAccordingToReturnExpression, 
            title:              "Change member type according to return expression", 
            isEnabledByDefault: true, 
            "CS0029", 
            "CS0127", 
            "CS0201", 
            "CS0246", 
            "CS0266", 
            "CS1997");

        /// <summary>RCF0081 (fixes CS0126)</summary>
        public static readonly CodeFixDescriptor ReturnDefaultValue = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReturnDefaultValue, 
            title:              "Return default value", 
            isEnabledByDefault: true, 
            "CS0126");

        /// <summary>RCF0082 (fixes CS0216)</summary>
        public static readonly CodeFixDescriptor DefineMatchingOperator = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.DefineMatchingOperator, 
            title:              "Define matching operator", 
            isEnabledByDefault: true, 
            "CS0216");

        /// <summary>RCF0083 (fixes CS0660)</summary>
        public static readonly CodeFixDescriptor DefineObjectEquals = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.DefineObjectEquals, 
            title:              "Define object.Equals", 
            isEnabledByDefault: true, 
            "CS0660");

        /// <summary>RCF0084 (fixes CS0659, CS0661)</summary>
        public static readonly CodeFixDescriptor DefineObjectGetHashCode = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.DefineObjectGetHashCode, 
            title:              "Define object.GetHashCode", 
            isEnabledByDefault: true, 
            "CS0659", 
            "CS0661");

        /// <summary>RCF0085 (fixes CS0246)</summary>
        public static readonly CodeFixDescriptor ChangeArrayType = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeArrayType, 
            title:              "Change array type", 
            isEnabledByDefault: true, 
            "CS0246");

        /// <summary>RCF0086 (fixes CS1031)</summary>
        public static readonly CodeFixDescriptor AddMissingType = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddMissingType, 
            title:              "Add missing type", 
            isEnabledByDefault: true, 
            "CS1031");

        /// <summary>RCF0087 (fixes CS0201)</summary>
        public static readonly CodeFixDescriptor ReplaceConditionalExpressionWithIfElse = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceConditionalExpressionWithIfElse, 
            title:              "Replace conditional expression with if-else", 
            isEnabledByDefault: true, 
            "CS0201");

        /// <summary>RCF0088 (fixes CS1597)</summary>
        public static readonly CodeFixDescriptor RemoveSemicolon = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveSemicolon, 
            title:              "Remove semicolon", 
            isEnabledByDefault: true, 
            "CS1597");

        /// <summary>RCF0089 (fixes CS0023)</summary>
        public static readonly CodeFixDescriptor RemoveConditionalAccess = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveConditionalAccess, 
            title:              "Remove conditional access", 
            isEnabledByDefault: true, 
            "CS0023");

        /// <summary>RCF0090 (fixes CS0029)</summary>
        public static readonly CodeFixDescriptor ChangeTypeAccordingToInitializer = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeTypeAccordingToInitializer, 
            title:              "Change type according to initializer", 
            isEnabledByDefault: true, 
            "CS0029");

        /// <summary>RCF0091 (fixes CS0030)</summary>
        public static readonly CodeFixDescriptor ChangeForEachType = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeForEachType, 
            title:              "Change foreach type", 
            isEnabledByDefault: true, 
            "CS0030");

        /// <summary>RCF0092 (fixes CS0029, CS0030)</summary>
        public static readonly CodeFixDescriptor ChangeTypeToVar = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeTypeToVar, 
            title:              "Change type to var", 
            isEnabledByDefault: true, 
            "CS0029", 
            "CS0030");

        /// <summary>RCF0093 (fixes CS1741, CS1743, CS1751)</summary>
        public static readonly CodeFixDescriptor RemoveDefaultValueFromParameter = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveDefaultValueFromParameter, 
            title:              "Remove default value from parameter", 
            isEnabledByDefault: true, 
            "CS1741", 
            "CS1743", 
            "CS1751");

        /// <summary>RCF0094 (fixes CS0133)</summary>
        public static readonly CodeFixDescriptor ReplaceConstantWithField = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceConstantWithField, 
            title:              "Replace constant with field", 
            isEnabledByDefault: true, 
            "CS0133");

        /// <summary>RCF0095 (fixes CS0527)</summary>
        public static readonly CodeFixDescriptor ReplaceStructWithClass = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceStructWithClass, 
            title:              "Replace struct with class", 
            isEnabledByDefault: true, 
            "CS0527");

        /// <summary>RCF0096 (fixes CS0029)</summary>
        public static readonly CodeFixDescriptor ReplaceYieldReturnWithForEach = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceYieldReturnWithForEach, 
            title:              "Replace yield return with foreach", 
            isEnabledByDefault: true, 
            "CS0029");

        /// <summary>RCF0097 (fixes CS0201)</summary>
        public static readonly CodeFixDescriptor ReplaceComparisonWithAssignment = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceComparisonWithAssignment, 
            title:              "Replace comparison with assignment", 
            isEnabledByDefault: true, 
            "CS0201");

        /// <summary>RCF0098 (fixes CS0501)</summary>
        public static readonly CodeFixDescriptor AddModifierAbstract = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddModifierAbstract, 
            title:              "Add modifier 'abstract'", 
            isEnabledByDefault: true, 
            "CS0501");

        /// <summary>RCF0099 (fixes CS8340)</summary>
        public static readonly CodeFixDescriptor MakeMemberReadOnly = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeMemberReadOnly, 
            title:              "Make member read-only'", 
            isEnabledByDefault: true, 
            "CS8340");

        /// <summary>RCF0100 (fixes CS0238)</summary>
        public static readonly CodeFixDescriptor RemoveSealedModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveSealedModifier, 
            title:              "Remove 'sealed' modifier", 
            isEnabledByDefault: true, 
            "CS0238");

        /// <summary>RCF0101 (fixes CS0549, CS0621)</summary>
        public static readonly CodeFixDescriptor RemoveVirtualModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveVirtualModifier, 
            title:              "Remove 'virtual' modifier", 
            isEnabledByDefault: true, 
            "CS0549", 
            "CS0621");

        /// <summary>RCF0102 (fixes CS0549)</summary>
        public static readonly CodeFixDescriptor MakeContainingClassUnsealed = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeContainingClassUnsealed, 
            title:              "Make containing class unsealed", 
            isEnabledByDefault: true, 
            "CS0549");

        /// <summary>RCF0103 (fixes CS0152)</summary>
        public static readonly CodeFixDescriptor RemoveSwitchLabel = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveSwitchLabel, 
            title:              "Remove switch label", 
            isEnabledByDefault: true, 
            "CS0152");

        /// <summary>RCF0104 (fixes CS0574)</summary>
        public static readonly CodeFixDescriptor RenameDestructorToMatchClassName = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RenameDestructorToMatchClassName, 
            title:              "Rename destructor to match class name", 
            isEnabledByDefault: true, 
            "CS0574");

        /// <summary>RCF0105 (fixes CS0713, CS0714)</summary>
        public static readonly CodeFixDescriptor RemoveBaseList = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveBaseList, 
            title:              "Remove base list", 
            isEnabledByDefault: true, 
            "CS0713", 
            "CS0714");

        /// <summary>RCF0106 (fixes CS1737)</summary>
        public static readonly CodeFixDescriptor AddDefaultValueToParameter = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddDefaultValueToParameter, 
            title:              "Add default value to parameter", 
            isEnabledByDefault: true, 
            "CS1737");

        /// <summary>RCF0107 (fixes CS1003)</summary>
        public static readonly CodeFixDescriptor AddMissingComma = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddMissingComma, 
            title:              "Add missing comma", 
            isEnabledByDefault: true, 
            "CS1003");

        /// <summary>RCF0108 (fixes CS0201)</summary>
        public static readonly CodeFixDescriptor RemoveParentheses = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveParentheses, 
            title:              "Remove parentheses", 
            isEnabledByDefault: true, 
            "CS0201");

        /// <summary>RCF0109 (fixes CS0136)</summary>
        public static readonly CodeFixDescriptor RemoveParameter = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveParameter, 
            title:              "Remove parameter", 
            isEnabledByDefault: true, 
            "CS0136");

        /// <summary>RCF0110 (fixes CS8139)</summary>
        public static readonly CodeFixDescriptor RenameTupleElement = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RenameTupleElement, 
            title:              "Rename tuple element to match overridden member", 
            isEnabledByDefault: true, 
            "CS8139");

        /// <summary>RCF0111 (fixes CS1750)</summary>
        public static readonly CodeFixDescriptor ChangeParameterType = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ChangeParameterType, 
            title:              "Change parameter type", 
            isEnabledByDefault: true, 
            "CS1750");

        /// <summary>RCF0112 (fixes CS3000, CS3001, CS3002, CS3003, CS3005, CS3006, CS3007, CS3008, CS3009, CS3016, CS3024, CS3027)</summary>
        public static readonly CodeFixDescriptor MarkDeclarationAsNonCLSCompliant = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MarkDeclarationAsNonCLSCompliant, 
            title:              "Mark declaration as non-CLS-compliant", 
            isEnabledByDefault: true, 
            "CS3000", 
            "CS3001", 
            "CS3002", 
            "CS3003", 
            "CS3005", 
            "CS3006", 
            "CS3007", 
            "CS3008", 
            "CS3009", 
            "CS3016", 
            "CS3024", 
            "CS3027");

        /// <summary>RCF0113 (fixes CS1012)</summary>
        public static readonly CodeFixDescriptor ReplaceCharacterLiteralWithStringLiteral = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceCharacterLiteralWithStringLiteral, 
            title:              "Replace character literal with string literal", 
            isEnabledByDefault: true, 
            "CS1012");

        /// <summary>RCF0114 (fixes CS0191, CS0192)</summary>
        public static readonly CodeFixDescriptor MakeFieldWritable = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MakeFieldWritable, 
            title:              "Make field writable", 
            isEnabledByDefault: true, 
            "CS0191", 
            "CS0192");

        /// <summary>RCF0115 (fixes CS1061)</summary>
        public static readonly CodeFixDescriptor ReplaceInvocationWithMemberAccessOrViceVersa = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.ReplaceInvocationWithMemberAccessOrViceVersa, 
            title:              "Replace invocation with member access or vice versa", 
            isEnabledByDefault: true, 
            "CS1061");

        /// <summary>RCF0116 (fixes CS0539)</summary>
        public static readonly CodeFixDescriptor AddParameterToExplicitlyImplementedInterfaceMember = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddParameterToExplicitlyImplementedInterfaceMember, 
            title:              "Add parameter to explicitly implemented interface member", 
            isEnabledByDefault: true, 
            "CS0539");

        /// <summary>RCF0117 (fixes CS7036)</summary>
        public static readonly CodeFixDescriptor MoveInitializerExpressionsToConstructor = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.MoveInitializerExpressionsToConstructor, 
            title:              "Move initializer expressions to constructor", 
            isEnabledByDefault: true, 
            "CS7036");

        /// <summary>RCF0118 (fixes CS8632)</summary>
        public static readonly CodeFixDescriptor RemoveAnnotationForNullableReferenceTypes = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.RemoveAnnotationForNullableReferenceTypes, 
            title:              "Remove annotation for nullable reference types", 
            isEnabledByDefault: true, 
            "CS8632");

        /// <summary>RCF0119 (fixes CS8604, CS8618, CS8625)</summary>
        public static readonly CodeFixDescriptor UseNullForgivingOperator = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.UseNullForgivingOperator, 
            title:              "Use null-forgiving operator", 
            isEnabledByDefault: true, 
            "CS8604", 
            "CS8618", 
            "CS8625");

        /// <summary>RCF0120 (fixes CS8403)</summary>
        public static readonly CodeFixDescriptor AddAsyncModifier = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddAsyncModifier, 
            title:              "Add 'async' modifier", 
            isEnabledByDefault: true, 
            "CS8403");

        /// <summary>RCF0121 (fixes CS8602)</summary>
        public static readonly CodeFixDescriptor UseNullPropagationOperator = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.UseNullPropagationOperator, 
            title:              "Use null propagation operator", 
            isEnabledByDefault: true, 
            "CS8602");

        /// <summary>RCF0122 (fixes CS8600, CS8610, CS8765, CS8767)</summary>
        public static readonly CodeFixDescriptor AddNullableAnnotation = new CodeFixDescriptor(
            id:                 CodeFixIdentifiers.AddNullableAnnotation, 
            title:              "Add nullable annotation", 
            isEnabledByDefault: true, 
            "CS8600", 
            "CS8610", 
            "CS8765", 
            "CS8767");

    }
}