﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using Microsoft.CodeAnalysis;
using Microsoft.CodeAnalysis.CSharp;
using Microsoft.CodeAnalysis.Text;

namespace Roslynator.CSharp.SyntaxRewriters;

internal sealed class TriviaRemover : CSharpSyntaxRewriter
{
    private TriviaRemover(TextSpan? span = null)
    {
        Span = span;
    }

    private static TriviaRemover Default { get; } = new();

    public TextSpan? Span { get; }

    public static SyntaxTrivia Replacement { get; } = CSharpFactory.EmptyWhitespace();

    public static TriviaRemover GetInstance(TextSpan? span = null)
    {
        if (span is not null)
        {
            return new TriviaRemover(span);
        }
        else
        {
            return Default;
        }
    }

    public override SyntaxTrivia VisitTrivia(SyntaxTrivia trivia)
    {
        if (Span?.Contains(trivia.Span) != false)
        {
            return Replacement;
        }

        return base.VisitTrivia(trivia);
    }
}
