﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Threading;
using System.Threading.Tasks;
using Microsoft.CodeAnalysis;
using Microsoft.CodeAnalysis.CSharp;
using Microsoft.CodeAnalysis.CSharp.Syntax;

namespace Roslynator.CSharp.Refactorings;

internal static class AddBracesRefactoring
{
    public static Task<Document> RefactorAsync(
        Document document,
        StatementSyntax statement,
        CancellationToken cancellationToken)
    {
        BlockSyntax block = SyntaxFactory.Block(statement);

        return document.ReplaceNodeAsync(statement, block, cancellationToken);
    }
}
