## VideoPlayerCode's MPV Utilities

* `[ Lua ]` **[auto-keep-gui-open.lua](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/auto-keep-gui-open.lua)**

  Intelligently switches mpv's "keep-open" behavior based on whether you are
  running in video-mode or audio-only mode.

* `[ JS ] TOP!` **[Blackbox.js](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/Blackbox.js)**

  Advanced, modular media browser, file manager and playlist manager for mpv.

* `[ JS ] TOP!` **[Colorbox.js](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/Colorbox.js)**

  Apply color correction presets.

* `[ Lua ]` **[cycle-video-rotate.lua](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/cycle-video-rotate.lua)**

  Allows you to perform video rotation which perfectly cycles through all 360
  degrees without any glitches.
  
* `[ JS ] TOP!` **[Gallerizer.js](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/Gallerizer.js)**

  Image gallery autoloader for mpv.

* `[ JS ] TOP!` **[Leapfrog.js](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/Leapfrog.js)**

  Effortlessly jump through your playlist, with your own custom jump size and
  direction, including the ability to jump randomly. Excellent when queuing lots
  of images and using mpv as an image viewer.

* `[ Lua ] TOP!` **[multi-command-if.lua](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/multi-command-if.lua)**

  Very powerful conditional logic and multiple action engine for your
  keybindings, without having to write a single line of code!

* `[ Lua ] TOP!` **[quick-scale.lua](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/quick-scale.lua)**

  Quickly scale the video player to a target size, with full control over target
  scale and max scale. Helps you effortlessly resize a video to fit on your
  desktop, or any other video dimensions you need!

* `[ JS ] TOP!` **[VideoPlayerCode's Modules.js (for developers)](https://github.com/VideoPlayerCode/mpv-tools/tree/master/scripts/modules.js)**

  Tons of pre-written, open source JavaScript modules which helps you rapidly
  create your own JS user scripts (including a very helpful [script config](https://github.com/VideoPlayerCode/mpv-tools/blob/master/scripts/modules.js/Options.js)
  system based on mpv's Lua `mp.options` API). All modules are free to use (and
  extend) in your own scripts!

### Download

Easily download all scripts as a zip file: [mpv-tools-master.zip](https://github.com/VideoPlayerCode/mpv-tools/archive/master.zip).

### Requirements

You need the [mpv.io](http://mpv.io) media player, built with Lua (`.lua`) and
JavaScript (`.js`) support. If you want to use any of the JavaScript utilities,
you must _also_ download the `scripts/modules.js/` folder and place it within
your own `scripts/` folder, exactly how it's laid out in this project. It
contains important sublibraries that are shared by all of my `.js` utilities.

### License

[Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0)

### Author

VideoPlayerCode (https://github.com/VideoPlayerCode)
