﻿// <auto-generated />
using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;
using Npgsql.EntityFrameworkCore.PostgreSQL.Metadata;
using Refresh.Database;

#nullable disable

namespace Refresh.Database.Migrations
{
    [DbContext(typeof(GameDatabaseContext))]
    partial class GameDatabaseContextModelSnapshot : ModelSnapshot
    {
        protected override void BuildModel(ModelBuilder modelBuilder)
        {
#pragma warning disable 612, 618
            modelBuilder
                .HasAnnotation("ProductVersion", "9.0.7")
                .HasAnnotation("Relational:MaxIdentifierLength", 63);

            NpgsqlModelBuilderExtensions.UseIdentityByDefaultColumns(modelBuilder);

            modelBuilder.Entity("Refresh.Database.Models.Activity.Event", b =>
                {
                    b.Property<string>("EventId")
                        .HasColumnType("text");

                    b.Property<byte>("EventType")
                        .HasColumnType("smallint");

                    b.Property<bool>("IsPrivate")
                        .HasColumnType("boolean");

                    b.Property<int>("StoredDataType")
                        .HasColumnType("integer");

                    b.Property<string>("StoredObjectId")
                        .HasColumnType("text");

                    b.Property<int?>("StoredSequentialId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("EventId");

                    b.HasIndex("Timestamp");

                    b.HasIndex("UserId");

                    b.ToTable("Events");
                });

            modelBuilder.Entity("Refresh.Database.Models.Assets.GameAsset", b =>
                {
                    b.Property<string>("AssetHash")
                        .HasColumnType("text");

                    b.Property<string>("AsMainlineIconHash")
                        .HasColumnType("text");

                    b.Property<string>("AsMainlinePhotoHash")
                        .HasColumnType("text");

                    b.Property<string>("AsMipIconHash")
                        .HasColumnType("text");

                    b.Property<byte>("AssetFormat")
                        .HasColumnType("smallint");

                    b.Property<int>("AssetType")
                        .HasColumnType("integer");

                    b.Property<bool>("IsPSP")
                        .HasColumnType("boolean");

                    b.Property<string>("OriginalUploaderUserId")
                        .HasColumnType("text");

                    b.Property<int>("SizeInBytes")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("UploadDate")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("AssetHash");

                    b.HasIndex("OriginalUploaderUserId");

                    b.ToTable("GameAssets");
                });

            modelBuilder.Entity("Refresh.Database.Models.Authentication.Token", b =>
                {
                    b.Property<string>("TokenId")
                        .HasColumnType("text");

                    b.Property<string>("Digest")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("ExpiresAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("IpAddress")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("IsHmacDigest")
                        .HasColumnType("boolean");

                    b.Property<DateTimeOffset>("LoginDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("TokenData")
                        .HasColumnType("text");

                    b.Property<int>("TokenGame")
                        .HasColumnType("integer");

                    b.Property<int>("TokenPlatform")
                        .HasColumnType("integer");

                    b.Property<int>("TokenType")
                        .HasColumnType("integer");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("TokenId");

                    b.HasIndex("UserId");

                    b.ToTable("Tokens");
                });

            modelBuilder.Entity("Refresh.Database.Models.Comments.GameLevelComment", b =>
                {
                    b.Property<int>("SequentialId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("SequentialId"));

                    b.Property<string>("AuthorUserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Content")
                        .HasColumnType("text");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("SequentialId");

                    b.HasIndex("AuthorUserId");

                    b.HasIndex("LevelId");

                    b.ToTable("GameLevelComments");
                });

            modelBuilder.Entity("Refresh.Database.Models.Comments.GameProfileComment", b =>
                {
                    b.Property<int>("SequentialId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("SequentialId"));

                    b.Property<string>("AuthorUserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Content")
                        .HasColumnType("text");

                    b.Property<string>("ProfileUserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("SequentialId");

                    b.HasIndex("AuthorUserId");

                    b.HasIndex("ProfileUserId");

                    b.ToTable("GameProfileComments");
                });

            modelBuilder.Entity("Refresh.Database.Models.Comments.GameReview", b =>
                {
                    b.Property<int>("ReviewId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("ReviewId"));

                    b.Property<string>("Content")
                        .HasColumnType("text");

                    b.Property<string>("Labels")
                        .HasColumnType("text");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("PostedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("PublisherUserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("ReviewId");

                    b.HasIndex("LevelId");

                    b.HasIndex("PublisherUserId");

                    b.ToTable("GameReviews");
                });

            modelBuilder.Entity("Refresh.Database.Models.Contests.GameContest", b =>
                {
                    b.Property<string>("ContestId")
                        .HasColumnType("text");

                    b.PrimitiveCollection<int[]>("AllowedGames")
                        .HasColumnType("integer[]");

                    b.Property<string>("BannerUrl")
                        .HasColumnType("text");

                    b.Property<string>("ContestDetails")
                        .HasColumnType("text");

                    b.Property<string>("ContestSummary")
                        .HasColumnType("text");

                    b.Property<string>("ContestTag")
                        .HasColumnType("text");

                    b.Property<string>("ContestTheme")
                        .HasColumnType("text");

                    b.Property<string>("ContestTitle")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("CreationDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<DateTimeOffset>("EndDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("OrganizerUserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("StartDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int?>("TemplateLevelLevelId")
                        .HasColumnType("integer");

                    b.HasKey("ContestId");

                    b.HasIndex("OrganizerUserId");

                    b.HasIndex("TemplateLevelLevelId");

                    b.ToTable("GameContests");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.Challenges.GameChallenge", b =>
                {
                    b.Property<int>("ChallengeId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("ChallengeId"));

                    b.Property<DateTimeOffset>("ExpirationDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("FinishCheckpointUid")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("LastUpdateDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<string>("Name")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("PublishDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("PublisherUserId")
                        .HasColumnType("text");

                    b.Property<int>("StartCheckpointUid")
                        .HasColumnType("integer");

                    b.Property<byte>("Type")
                        .HasColumnType("smallint");

                    b.HasKey("ChallengeId");

                    b.HasIndex("LevelId");

                    b.HasIndex("PublisherUserId");

                    b.ToTable("GameChallenges");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.Challenges.GameChallengeScore", b =>
                {
                    b.Property<string>("ScoreId")
                        .HasColumnType("text");

                    b.Property<int>("ChallengeId")
                        .HasColumnType("integer");

                    b.Property<string>("GhostHash")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("PublishDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("PublisherUserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<long>("Score")
                        .HasColumnType("bigint");

                    b.Property<long>("Time")
                        .HasColumnType("bigint");

                    b.HasKey("ScoreId");

                    b.HasIndex("ChallengeId");

                    b.HasIndex("PublisherUserId");

                    b.ToTable("GameChallengeScores");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.GameLevel", b =>
                {
                    b.Property<int>("LevelId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("LevelId"));

                    b.Property<string>("BackgroundGuid")
                        .HasColumnType("text");

                    b.Property<float>("CoolRating")
                        .HasColumnType("real");

                    b.Property<DateTimeOffset?>("DateTeamPicked")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Description")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("EnforceMinMaxPlayers")
                        .HasColumnType("boolean");

                    b.Property<int>("GameVersion")
                        .HasColumnType("integer");

                    b.Property<string>("IconHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("IsAdventure")
                        .HasColumnType("boolean");

                    b.Property<bool>("IsCopyable")
                        .HasColumnType("boolean");

                    b.Property<bool>("IsLocked")
                        .HasColumnType("boolean");

                    b.Property<bool>("IsModded")
                        .HasColumnType("boolean");

                    b.Property<bool>("IsReUpload")
                        .HasColumnType("boolean");

                    b.Property<bool>("IsSubLevel")
                        .HasColumnType("boolean");

                    b.Property<byte>("LevelType")
                        .HasColumnType("smallint");

                    b.Property<int>("LocationX")
                        .HasColumnType("integer");

                    b.Property<int>("LocationY")
                        .HasColumnType("integer");

                    b.Property<int>("MaxPlayers")
                        .HasColumnType("integer");

                    b.Property<int>("MinPlayers")
                        .HasColumnType("integer");

                    b.Property<string>("OriginalPublisher")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("PublishDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("PublisherUserId")
                        .HasColumnType("text");

                    b.Property<bool>("RequiresMoveController")
                        .HasColumnType("boolean");

                    b.Property<string>("RootResource")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("SameScreenGame")
                        .HasColumnType("boolean");

                    b.Property<int?>("StatisticsLevelId")
                        .HasColumnType("integer");

                    b.Property<int>("StoryId")
                        .HasColumnType("integer");

                    b.Property<string>("Title")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("UpdateDate")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("LevelId");

                    b.HasIndex("PublisherUserId");

                    b.HasIndex("StatisticsLevelId");

                    b.HasIndex("Title", "Description", "StoryId");

                    b.ToTable("GameLevels");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.GameLevelRevision", b =>
                {
                    b.Property<int>("RevisionId")
                        .HasColumnType("integer");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("CreatedById")
                        .HasColumnType("text");

                    b.Property<string>("Description")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<int>("GameVersion")
                        .HasColumnType("integer");

                    b.Property<string>("IconHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<byte>("LevelType")
                        .HasColumnType("smallint");

                    b.Property<string>("RootResource")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<int>("StoryId")
                        .HasColumnType("integer");

                    b.Property<string>("Title")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("RevisionId", "LevelId");

                    b.HasIndex("CreatedById");

                    b.HasIndex("LevelId");

                    b.ToTable("GameLevelRevisions");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.GameSkillReward", b =>
                {
                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<int>("Id")
                        .HasColumnType("integer");

                    b.Property<int>("ConditionType")
                        .HasColumnType("integer");

                    b.Property<bool>("Enabled")
                        .HasColumnType("boolean");

                    b.Property<float>("RequiredAmount")
                        .HasColumnType("real");

                    b.Property<string>("Title")
                        .HasColumnType("text");

                    b.HasKey("LevelId", "Id");

                    b.ToTable("GameSkillRewards");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.Scores.GameScore", b =>
                {
                    b.Property<string>("ScoreId")
                        .HasColumnType("text");

                    b.Property<int>("Game")
                        .HasColumnType("integer");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<int>("Platform")
                        .HasColumnType("integer");

                    b.PrimitiveCollection<List<string>>("PlayerIdsRaw")
                        .HasColumnType("text[]");

                    b.Property<int>("Score")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("ScoreSubmitted")
                        .HasColumnType("timestamp with time zone");

                    b.Property<byte>("ScoreType")
                        .HasColumnType("smallint");

                    b.HasKey("ScoreId");

                    b.HasIndex("LevelId");

                    b.HasIndex("Game", "Score", "ScoreType");

                    b.ToTable("GameScores");
                });

            modelBuilder.Entity("Refresh.Database.Models.Notifications.GameAnnouncement", b =>
                {
                    b.Property<string>("AnnouncementId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Text")
                        .HasColumnType("text");

                    b.Property<string>("Title")
                        .HasColumnType("text");

                    b.HasKey("AnnouncementId");

                    b.ToTable("GameAnnouncements");
                });

            modelBuilder.Entity("Refresh.Database.Models.Notifications.GameNotification", b =>
                {
                    b.Property<string>("NotificationId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("FontAwesomeIcon")
                        .HasColumnType("text");

                    b.Property<string>("Text")
                        .HasColumnType("text");

                    b.Property<string>("Title")
                        .HasColumnType("text");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("NotificationId");

                    b.HasIndex("UserId");

                    b.ToTable("GameNotifications");
                });

            modelBuilder.Entity("Refresh.Database.Models.Photos.GamePhoto", b =>
                {
                    b.Property<int>("PhotoId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("PhotoId"));

                    b.Property<string>("LargeAssetHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<int?>("LevelId")
                        .HasColumnType("integer");

                    b.Property<string>("LevelType")
                        .HasColumnType("text");

                    b.Property<string>("MediumAssetHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<int>("OriginalLevelId")
                        .HasColumnType("integer");

                    b.Property<string>("OriginalLevelName")
                        .HasColumnType("text");

                    b.Property<string>("PlanHash")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("PublishedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("PublisherId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("SmallAssetHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.PrimitiveCollection<List<float>>("Subject1Bounds")
                        .IsRequired()
                        .HasColumnType("real[]");

                    b.Property<string>("Subject1DisplayName")
                        .HasColumnType("text");

                    b.Property<string>("Subject1UserId")
                        .HasColumnType("text");

                    b.PrimitiveCollection<List<float>>("Subject2Bounds")
                        .IsRequired()
                        .HasColumnType("real[]");

                    b.Property<string>("Subject2DisplayName")
                        .HasColumnType("text");

                    b.Property<string>("Subject2UserId")
                        .HasColumnType("text");

                    b.PrimitiveCollection<List<float>>("Subject3Bounds")
                        .IsRequired()
                        .HasColumnType("real[]");

                    b.Property<string>("Subject3DisplayName")
                        .HasColumnType("text");

                    b.Property<string>("Subject3UserId")
                        .HasColumnType("text");

                    b.PrimitiveCollection<List<float>>("Subject4Bounds")
                        .IsRequired()
                        .HasColumnType("real[]");

                    b.Property<string>("Subject4DisplayName")
                        .HasColumnType("text");

                    b.Property<string>("Subject4UserId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("TakenAt")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("PhotoId");

                    b.HasIndex("LargeAssetHash");

                    b.HasIndex("LevelId");

                    b.HasIndex("MediumAssetHash");

                    b.HasIndex("PublisherId");

                    b.HasIndex("SmallAssetHash");

                    b.HasIndex("Subject1UserId");

                    b.HasIndex("Subject2UserId");

                    b.HasIndex("Subject3UserId");

                    b.HasIndex("Subject4UserId");

                    b.ToTable("GamePhotos");
                });

            modelBuilder.Entity("Refresh.Database.Models.Playlists.GamePlaylist", b =>
                {
                    b.Property<int>("PlaylistId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("PlaylistId"));

                    b.Property<DateTimeOffset>("CreationDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Description")
                        .HasColumnType("text");

                    b.Property<string>("IconHash")
                        .HasColumnType("text");

                    b.Property<bool>("IsRoot")
                        .HasColumnType("boolean");

                    b.Property<DateTimeOffset>("LastUpdateDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("LocationX")
                        .HasColumnType("integer");

                    b.Property<int>("LocationY")
                        .HasColumnType("integer");

                    b.Property<string>("Name")
                        .HasColumnType("text");

                    b.Property<string>("PublisherId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("PlaylistId");

                    b.HasIndex("PublisherId");

                    b.ToTable("GamePlaylists");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.AssetDependencyRelation", b =>
                {
                    b.Property<string>("Dependent")
                        .HasColumnType("text");

                    b.Property<string>("Dependency")
                        .HasColumnType("text");

                    b.HasKey("Dependent", "Dependency");

                    b.ToTable("AssetDependencyRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.FavouriteLevelRelation", b =>
                {
                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("LevelId", "UserId");

                    b.HasIndex("UserId");

                    b.ToTable("FavouriteLevelRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.FavouritePlaylistRelation", b =>
                {
                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<int>("PlaylistId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("UserId", "PlaylistId");

                    b.HasIndex("PlaylistId");

                    b.ToTable("FavouritePlaylistRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.FavouriteUserRelation", b =>
                {
                    b.Property<string>("UserToFavouriteId")
                        .HasColumnType("text");

                    b.Property<string>("UserFavouritingId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("UserToFavouriteId", "UserFavouritingId");

                    b.HasIndex("UserFavouritingId");

                    b.ToTable("FavouriteUserRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.GameUserVerifiedIpRelation", b =>
                {
                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<string>("IpAddress")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("VerifiedAt")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("UserId", "IpAddress");

                    b.ToTable("GameUserVerifiedIpRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.LevelCommentRelation", b =>
                {
                    b.Property<string>("CommentRelationId")
                        .HasColumnType("text");

                    b.Property<int>("CommentSequentialId")
                        .HasColumnType("integer");

                    b.Property<short>("RatingType")
                        .HasColumnType("smallint");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("CommentRelationId");

                    b.HasIndex("CommentSequentialId");

                    b.HasIndex("UserId");

                    b.ToTable("LevelCommentRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.LevelPlaylistRelation", b =>
                {
                    b.Property<int>("PlaylistId")
                        .HasColumnType("integer");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<int>("Index")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("PlaylistId", "LevelId");

                    b.HasIndex("LevelId");

                    b.ToTable("LevelPlaylistRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.PinProgressRelation", b =>
                {
                    b.Property<long>("PinId")
                        .HasColumnType("bigint");

                    b.Property<string>("PublisherId")
                        .HasColumnType("text");

                    b.Property<bool>("IsBeta")
                        .HasColumnType("boolean");

                    b.Property<DateTimeOffset>("FirstPublished")
                        .HasColumnType("timestamp with time zone");

                    b.Property<DateTimeOffset>("LastUpdated")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("Progress")
                        .HasColumnType("integer");

                    b.HasKey("PinId", "PublisherId", "IsBeta");

                    b.HasIndex("PublisherId");

                    b.ToTable("PinProgressRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.PlayLevelRelation", b =>
                {
                    b.Property<string>("PlayId")
                        .HasColumnType("text");

                    b.Property<int>("Count")
                        .HasColumnType("integer");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("PlayId");

                    b.HasIndex("LevelId");

                    b.HasIndex("UserId");

                    b.ToTable("PlayLevelRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.ProfileCommentRelation", b =>
                {
                    b.Property<string>("CommentRelationId")
                        .HasColumnType("text");

                    b.Property<int>("CommentSequentialId")
                        .HasColumnType("integer");

                    b.Property<short>("RatingType")
                        .HasColumnType("smallint");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("CommentRelationId");

                    b.HasIndex("CommentSequentialId");

                    b.HasIndex("UserId");

                    b.ToTable("ProfileCommentRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.ProfilePinRelation", b =>
                {
                    b.Property<int>("Index")
                        .HasColumnType("integer");

                    b.Property<string>("PublisherId")
                        .HasColumnType("text");

                    b.Property<int>("Game")
                        .HasColumnType("integer");

                    b.Property<long>("PinId")
                        .HasColumnType("bigint");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("Index", "PublisherId", "Game");

                    b.HasIndex("PublisherId");

                    b.ToTable("ProfilePinRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.QueueLevelRelation", b =>
                {
                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("LevelId", "UserId");

                    b.HasIndex("UserId");

                    b.ToTable("QueueLevelRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.RateLevelRelation", b =>
                {
                    b.Property<string>("RateLevelRelationId")
                        .HasColumnType("text");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<short>("RatingType")
                        .HasColumnType("smallint");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("RateLevelRelationId");

                    b.HasIndex("LevelId");

                    b.HasIndex("UserId");

                    b.ToTable("RateLevelRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.RateReviewRelation", b =>
                {
                    b.Property<int>("ReviewId")
                        .HasColumnType("integer");

                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<short>("RatingType")
                        .HasColumnType("smallint");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("ReviewId", "UserId");

                    b.HasIndex("UserId");

                    b.ToTable("RateReviewRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.SubPlaylistRelation", b =>
                {
                    b.Property<int>("PlaylistId")
                        .HasColumnType("integer");

                    b.Property<int>("SubPlaylistId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("PlaylistId", "SubPlaylistId");

                    b.HasIndex("SubPlaylistId");

                    b.ToTable("SubPlaylistRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.TagLevelRelation", b =>
                {
                    b.Property<byte>("Tag")
                        .HasColumnType("smallint");

                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("Tag", "UserId", "LevelId");

                    b.HasIndex("LevelId");

                    b.HasIndex("UserId");

                    b.ToTable("TagLevelRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.UniquePlayLevelRelation", b =>
                {
                    b.Property<int>("LevelId")
                        .HasColumnType("integer");

                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("Timestamp")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("LevelId", "UserId");

                    b.HasIndex("UserId");

                    b.ToTable("UniquePlayLevelRelations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Statistics.GameLevelStatistics", b =>
                {
                    b.Property<int>("LevelId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("LevelId"));

                    b.Property<int>("BooCount")
                        .HasColumnType("integer");

                    b.Property<int>("BooCountExcludingPublisher")
                        .HasColumnType("integer");

                    b.Property<int>("CommentCount")
                        .HasColumnType("integer");

                    b.Property<int>("CompletionCount")
                        .HasColumnType("integer");

                    b.Property<int>("FavouriteCount")
                        .HasColumnType("integer");

                    b.Property<int>("FavouriteCountExcludingPublisher")
                        .HasColumnType("integer");

                    b.Property<int>("Karma")
                        .HasColumnType("integer");

                    b.Property<int>("NeutralCount")
                        .HasColumnType("integer");

                    b.Property<int>("NeutralCountExcludingPublisher")
                        .HasColumnType("integer");

                    b.Property<int>("PhotoByPublisherCount")
                        .HasColumnType("integer");

                    b.Property<int>("PhotoInLevelCount")
                        .HasColumnType("integer");

                    b.Property<int>("PlayCount")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset?>("RecalculateAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("ReviewCount")
                        .HasColumnType("integer");

                    b.Property<int>("UniquePlayCount")
                        .HasColumnType("integer");

                    b.Property<int>("UniquePlayCountExcludingPublisher")
                        .HasColumnType("integer");

                    b.Property<int>("Version")
                        .HasColumnType("integer");

                    b.Property<int>("YayCount")
                        .HasColumnType("integer");

                    b.Property<int>("YayCountExcludingPublisher")
                        .HasColumnType("integer");

                    b.HasKey("LevelId");

                    b.ToTable("GameLevelStatistics");
                });

            modelBuilder.Entity("Refresh.Database.Models.Statistics.GameUserStatistics", b =>
                {
                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<int>("CommentCount")
                        .HasColumnType("integer");

                    b.Property<int>("FavouriteCount")
                        .HasColumnType("integer");

                    b.Property<int>("FavouriteLevelCount")
                        .HasColumnType("integer");

                    b.Property<int>("FavouriteUserCount")
                        .HasColumnType("integer");

                    b.Property<int>("LevelCount")
                        .HasColumnType("integer");

                    b.Property<int>("PhotosByUserCount")
                        .HasColumnType("integer");

                    b.Property<int>("PhotosWithUserCount")
                        .HasColumnType("integer");

                    b.Property<int>("QueueCount")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset?>("RecalculateAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("ReviewCount")
                        .HasColumnType("integer");

                    b.Property<int>("Version")
                        .HasColumnType("integer");

                    b.HasKey("UserId");

                    b.ToTable("GameUserStatistics");
                });

            modelBuilder.Entity("Refresh.Database.Models.Statistics.RequestStatistics", b =>
                {
                    b.Property<int>("Id")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("Id"));

                    b.Property<long>("ApiRequests")
                        .HasColumnType("bigint");

                    b.Property<long>("GameRequests")
                        .HasColumnType("bigint");

                    b.HasKey("Id");

                    b.ToTable("RequestStatistics");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.DisallowedUser", b =>
                {
                    b.Property<string>("Username")
                        .HasColumnType("text");

                    b.HasKey("Username");

                    b.ToTable("DisallowedUsers");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.EmailVerificationCode", b =>
                {
                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<string>("Code")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("ExpiryDate")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("UserId", "Code");

                    b.ToTable("EmailVerificationCodes");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.GameIpVerificationRequest", b =>
                {
                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<string>("IpAddress")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("UserId", "IpAddress");

                    b.ToTable("GameIpVerificationRequests");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.GameUser", b =>
                {
                    b.Property<string>("UserId")
                        .HasColumnType("text");

                    b.Property<bool>("AllowIpAuthentication")
                        .HasColumnType("boolean");

                    b.Property<DateTimeOffset?>("BanExpiryDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("BanReason")
                        .HasColumnType("text");

                    b.Property<string>("BetaIconHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("BetaPlanetsHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("BooFaceHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Description")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("EmailAddress")
                        .HasColumnType("text");

                    b.Property<bool>("EmailAddressVerified")
                        .HasColumnType("boolean");

                    b.Property<int>("FilesizeQuotaUsage")
                        .HasColumnType("integer");

                    b.Property<string>("ForceMatch")
                        .HasColumnType("text");

                    b.Property<string>("IconHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("JoinDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<DateTimeOffset>("LastLoginDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Lbp2PlanetsHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Lbp3PlanetsHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<int>("LevelVisibility")
                        .HasColumnType("integer");

                    b.Property<int>("LocationX")
                        .HasColumnType("integer");

                    b.Property<int>("LocationY")
                        .HasColumnType("integer");

                    b.Property<string>("MehFaceHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("PasswordBcrypt")
                        .HasColumnType("text");

                    b.Property<string>("PresenceServerAuthToken")
                        .HasColumnType("text");

                    b.Property<int>("ProfileVisibility")
                        .HasColumnType("integer");

                    b.Property<bool>("PsnAuthenticationAllowed")
                        .HasColumnType("boolean");

                    b.Property<string>("PspIconHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<short>("Role")
                        .HasColumnType("smallint");

                    b.Property<bool>("RpcnAuthenticationAllowed")
                        .HasColumnType("boolean");

                    b.Property<bool>("ShouldResetPassword")
                        .HasColumnType("boolean");

                    b.Property<bool>("ShowModdedContent")
                        .HasColumnType("boolean");

                    b.Property<bool>("ShowReuploadedContent")
                        .HasColumnType("boolean");

                    b.Property<string>("StatisticsUserId")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset?>("TimedLevelUploadExpiryDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("TimedLevelUploads")
                        .HasColumnType("integer");

                    b.Property<bool>("UnescapeXmlSequences")
                        .HasColumnType("boolean");

                    b.Property<string>("Username")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("UsernameLower")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("VitaIconHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("VitaPlanetsHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("YayFaceHash")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("UserId");

                    b.HasIndex("StatisticsUserId");

                    b.HasIndex("Username", "UsernameLower", "EmailAddress", "PasswordBcrypt");

                    b.ToTable("GameUsers");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.QueuedRegistration", b =>
                {
                    b.Property<string>("RegistrationId")
                        .HasColumnType("text");

                    b.Property<string>("EmailAddress")
                        .HasColumnType("text");

                    b.Property<DateTimeOffset>("ExpiryDate")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("PasswordBcrypt")
                        .HasColumnType("text");

                    b.Property<string>("Username")
                        .HasColumnType("text");

                    b.Property<string>("UsernameLower")
                        .HasColumnType("text");

                    b.HasKey("RegistrationId");

                    b.HasIndex("Username", "UsernameLower", "EmailAddress");

                    b.ToTable("QueuedRegistrations");
                });

            modelBuilder.Entity("Refresh.Database.Models.Workers.PersistentJobState", b =>
                {
                    b.Property<string>("JobId")
                        .HasColumnType("text");

                    b.Property<string>("State")
                        .IsRequired()
                        .HasColumnType("jsonb");

                    b.HasKey("JobId");

                    b.ToTable("JobStates");
                });

            modelBuilder.Entity("Refresh.Database.Models.Workers.WorkerInfo", b =>
                {
                    b.Property<int>("WorkerId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("integer");

                    NpgsqlPropertyBuilderExtensions.UseIdentityByDefaultColumn(b.Property<int>("WorkerId"));

                    b.Property<int>("Class")
                        .HasColumnType("integer");

                    b.Property<DateTimeOffset>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<DateTimeOffset>("LastContact")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("WorkerId");

                    b.ToTable("Workers");
                });

            modelBuilder.Entity("Refresh.Database.Models.Activity.Event", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Assets.GameAsset", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "OriginalUploader")
                        .WithMany()
                        .HasForeignKey("OriginalUploaderUserId");

                    b.Navigation("OriginalUploader");
                });

            modelBuilder.Entity("Refresh.Database.Models.Authentication.Token", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Comments.GameLevelComment", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Author")
                        .WithMany()
                        .HasForeignKey("AuthorUserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Author");

                    b.Navigation("Level");
                });

            modelBuilder.Entity("Refresh.Database.Models.Comments.GameProfileComment", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Author")
                        .WithMany()
                        .HasForeignKey("AuthorUserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Profile")
                        .WithMany()
                        .HasForeignKey("ProfileUserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Author");

                    b.Navigation("Profile");
                });

            modelBuilder.Entity("Refresh.Database.Models.Comments.GameReview", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherUserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("Publisher");
                });

            modelBuilder.Entity("Refresh.Database.Models.Contests.GameContest", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Organizer")
                        .WithMany()
                        .HasForeignKey("OrganizerUserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "TemplateLevel")
                        .WithMany()
                        .HasForeignKey("TemplateLevelLevelId");

                    b.Navigation("Organizer");

                    b.Navigation("TemplateLevel");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.Challenges.GameChallenge", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherUserId");

                    b.Navigation("Level");

                    b.Navigation("Publisher");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.Challenges.GameChallengeScore", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.Challenges.GameChallenge", "Challenge")
                        .WithMany()
                        .HasForeignKey("ChallengeId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherUserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Challenge");

                    b.Navigation("Publisher");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.GameLevel", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherUserId");

                    b.HasOne("Refresh.Database.Models.Statistics.GameLevelStatistics", "Statistics")
                        .WithMany()
                        .HasForeignKey("StatisticsLevelId");

                    b.Navigation("Publisher");

                    b.Navigation("Statistics");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.GameLevelRevision", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "CreatedBy")
                        .WithMany()
                        .HasForeignKey("CreatedById");

                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("CreatedBy");

                    b.Navigation("Level");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.GameSkillReward", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");
                });

            modelBuilder.Entity("Refresh.Database.Models.Levels.Scores.GameScore", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");
                });

            modelBuilder.Entity("Refresh.Database.Models.Notifications.GameNotification", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Photos.GamePhoto", b =>
                {
                    b.HasOne("Refresh.Database.Models.Assets.GameAsset", "LargeAsset")
                        .WithMany()
                        .HasForeignKey("LargeAssetHash")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId");

                    b.HasOne("Refresh.Database.Models.Assets.GameAsset", "MediumAsset")
                        .WithMany()
                        .HasForeignKey("MediumAssetHash")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Assets.GameAsset", "SmallAsset")
                        .WithMany()
                        .HasForeignKey("SmallAssetHash")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Subject1User")
                        .WithMany()
                        .HasForeignKey("Subject1UserId");

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Subject2User")
                        .WithMany()
                        .HasForeignKey("Subject2UserId");

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Subject3User")
                        .WithMany()
                        .HasForeignKey("Subject3UserId");

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Subject4User")
                        .WithMany()
                        .HasForeignKey("Subject4UserId");

                    b.Navigation("LargeAsset");

                    b.Navigation("Level");

                    b.Navigation("MediumAsset");

                    b.Navigation("Publisher");

                    b.Navigation("SmallAsset");

                    b.Navigation("Subject1User");

                    b.Navigation("Subject2User");

                    b.Navigation("Subject3User");

                    b.Navigation("Subject4User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Playlists.GamePlaylist", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Publisher");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.FavouriteLevelRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.FavouritePlaylistRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Playlists.GamePlaylist", "Playlist")
                        .WithMany()
                        .HasForeignKey("PlaylistId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Playlist");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.FavouriteUserRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "UserFavouriting")
                        .WithMany()
                        .HasForeignKey("UserFavouritingId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "UserToFavourite")
                        .WithMany()
                        .HasForeignKey("UserToFavouriteId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("UserFavouriting");

                    b.Navigation("UserToFavourite");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.GameUserVerifiedIpRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.LevelCommentRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Comments.GameLevelComment", "Comment")
                        .WithMany()
                        .HasForeignKey("CommentSequentialId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Comment");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.LevelPlaylistRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Playlists.GamePlaylist", "Playlist")
                        .WithMany()
                        .HasForeignKey("PlaylistId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("Playlist");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.PinProgressRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Publisher");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.PlayLevelRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.ProfileCommentRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Comments.GameProfileComment", "Comment")
                        .WithMany()
                        .HasForeignKey("CommentSequentialId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Comment");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.ProfilePinRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "Publisher")
                        .WithMany()
                        .HasForeignKey("PublisherId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Publisher");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.QueueLevelRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.RateLevelRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.RateReviewRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Comments.GameReview", "Review")
                        .WithMany()
                        .HasForeignKey("ReviewId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Review");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.SubPlaylistRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Playlists.GamePlaylist", "Playlist")
                        .WithMany()
                        .HasForeignKey("PlaylistId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Playlists.GamePlaylist", "SubPlaylist")
                        .WithMany()
                        .HasForeignKey("SubPlaylistId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Playlist");

                    b.Navigation("SubPlaylist");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.TagLevelRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Relations.UniquePlayLevelRelation", b =>
                {
                    b.HasOne("Refresh.Database.Models.Levels.GameLevel", "Level")
                        .WithMany()
                        .HasForeignKey("LevelId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("Level");

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.EmailVerificationCode", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.GameIpVerificationRequest", b =>
                {
                    b.HasOne("Refresh.Database.Models.Users.GameUser", "User")
                        .WithMany()
                        .HasForeignKey("UserId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("User");
                });

            modelBuilder.Entity("Refresh.Database.Models.Users.GameUser", b =>
                {
                    b.HasOne("Refresh.Database.Models.Statistics.GameUserStatistics", "Statistics")
                        .WithMany()
                        .HasForeignKey("StatisticsUserId");

                    b.Navigation("Statistics");
                });
#pragma warning restore 612, 618
        }
    }
}
