package testing.breakout.strategy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

import com.fxcm.fix.Instrument;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;

import building.breakout.strategy.*;
import pulling.historical.prices.breakout.CandleStick;
import pulling.historical.prices.breakout.HistoryMiner;
import pulling.historical.prices.breakout.RatesToCandlesticks;
import pulling.historical.prices.breakout.Utilities;

public class TesterClass {

	public static void main(String[] args){
		List <CandleStick> candleSticksList;
		double stopLoss=0.003;
		double takeProfit=0.003;
		int bottomRSI=10; List <StrategyResult> strategySummary = new ArrayList<StrategyResult>();
		UTCDate startDate;
		UTCTimeOnly startTime;
		Instrument asset = new Instrument("AUD/USD");
		// get the current time and roll back 1 year
		Calendar instance = Calendar.getInstance();
		instance.roll(Calendar.DAY_OF_YEAR, -20);
		// set the starting date and time of the historical data
		startDate = new UTCDate(instance.getTime());
		startTime = new UTCTimeOnly(instance.getTime());
		
		try{
			HistoryMiner miner = new HistoryMiner("D25611997", "6925", "Demo", startDate, startTime, asset);
			miner.login(miner,miner);
			while(miner.stillMining) {
				Thread.sleep(1000);
			}
			Thread.sleep(1000);
			miner.logout(miner,miner);
			candleSticksList = miner.candleStickList;
			RatesToCandlesticks rtc = new RatesToCandlesticks();
			rtc.convertHistoricalRatesToCandleSticks(miner.getHistoricalRates(), candleSticksList);
			DisplayResults ds = new DisplayResults();
			ds.displayHistory(candleSticksList);
			System.out.println("LINE 1111111111");
			BreakoutStrategy.calculateDonchianIndicatorForDataSet(candleSticksList, 14);
			System.out.println("LINE 222222222222222222222");
			System.out.println("LINE 33333333333333");
			for (double i = stopLoss; i < stopLoss+0.005 ; i+=0.0005) { 
				for (double j = takeProfit; j < takeProfit+0.005; j+=0.0005) { 
					for (double k = bottomRSI; k <= bottomRSI+10; k+=5) { 
						Strategy breakoutStrategy = new BreakoutStrategy(i, j, k);
						StrategyResult sr = ((BreakoutStrategy) breakoutStrategy).runStrategy(candleSticksList);
						strategySummary.add(sr);
					}
				}
			}
			System.out.println("LINE 444444444444444444");

			Collections.sort(strategySummary,new StrategyResult()); // sort results list
			double averageProfit=StrategyResult.calculateAvgStrategyProfit(strategySummary);
			System.out.println("Average profit=> "+(double)Math.round(10000*averageProfit)/100+"%");
			System.out.println("10 best results ______________________________________________________________ ");
			for (int i = 0; i < 10; i++) {
				BreakoutStrategy bos = (BreakoutStrategy) strategySummary.get(i).getStrategy();
				System.out.println("profit:"+(double)Math.round(strategySummary.get(i).getProfit()*10000)/100 +"%" +
						" | max-drawdown:"+(double)Math.round(strategySummary.get(i).getMaxDrawdown()*10000)/100 +"%" +
						" | wins:"+(double)Math.round(10000*strategySummary.get(i).getWinsRatio())/100 + "%" +
						" | losses:"+(double)Math.round(10000*strategySummary.get(i).getLossesRatio())/100 + "%" +
						" | s-l:"+(double)Math.round(bos.getSTOP_LOSS()*10000)/100 +"%" +
						" | t-p:"+(double)Math.round(bos.getTAKE_PROFIT()*10000)/100 +"%" +
						" | bottom-rsi:"+bos.getFLOOR_DONCHIAN() +
						" | top-rsi:"+bos.getCEILING_DONCHIAN() + "\n");
			}
			System.out.println("10 worst results _____________________________________________________________ ");
			for (int i = strategySummary.size()-1; i > strategySummary.size()-11; i--) {
				BreakoutStrategy bos = (BreakoutStrategy) strategySummary.get(i).getStrategy();
				System.out.println("profit: "+(double)Math.round(strategySummary.get(i).getProfit()*10000)/100+"%" +
						" | max-drawdown:"+(double)Math.round(strategySummary.get(i).getMaxDrawdown()*10000)/100 +"%" +
						" | wins:"+(double)Math.round(10000*strategySummary.get(i).getWinsRatio())/100 + "%" +
						" | losses:"+(double)Math.round(10000*strategySummary.get(i).getLossesRatio())/100 + "%" +
						" | s-l:"+(double)Math.round(bos.getSTOP_LOSS()*10000)/100 +"%" +
						" | t-p:"+(double)Math.round(bos.getSTOP_LOSS()*10000)/100 +"%" +
						" | bottom-rsi:"+bos.getFLOOR_DONCHIAN() +
						" | top-rsi:"+bos.getCEILING_DONCHIAN() + "\n");
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
}