package testing.breakout.strategy;

import java.util.ArrayList;

import java.util.Calendar;
import java.util.List;

import com.fxcm.fix.Instrument;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;

import pulling.historical.prices.breakout.CandleStick;
import pulling.historical.prices.breakout.HistoryMiner;
import pulling.historical.prices.breakout.RatesToCandlesticks;


public class SampleTesting {

	public static void main(String[] args) {
		List <CandleStick> candleSticksList = null;
		UTCDate startDate;
		UTCTimeOnly startTime;
		Instrument asset = new Instrument("EUR/USD");
		RatesToCandlesticks rtc = new RatesToCandlesticks();
		building.breakout.strategy.DisplayResults ds = new building.breakout.strategy.DisplayResults();
		Calendar instance = Calendar.getInstance();
		instance.roll(Calendar.DAY_OF_YEAR, -20);
		startDate = new UTCDate(instance.getTime());
		startTime = new UTCTimeOnly(instance.getTime());
		try{
			HistoryMiner miner = new HistoryMiner("D25611997", "6925", "Demo", startDate,startTime, asset);
			miner.login(miner,miner);
			while(miner.stillMining) {
				Thread.sleep(1000);
			}
			Thread.sleep(1000);
			miner.logout(miner,miner);
			candleSticksList = miner.candleStickList;
			rtc.convertHistoricalRatesToCandleSticks(miner.getHistoricalRates(), candleSticksList);
			ds.displayHistory(candleSticksList);
			List<Double> twentyDayHighs = new ArrayList<>();
			List<Double> twentyDayLows = new ArrayList<>();
			for (int i = 0; i < candleSticksList.size(); i++) {
				System.out.println(candleSticksList.get(i).getHigh() + "\n");
				System.out.println(candleSticksList.get(i).getHigh() + "\n");
				twentyDayHighs.add(candleSticksList.get(i).getHigh());
				twentyDayLows.add(candleSticksList.get(i).getLow());
			}
			System.out.println(twentyDayHighs);
			System.out.println(twentyDayLows);
		}catch(Exception e) {
			e.printStackTrace();
		}
	}

}
