package building.breakout.strategy;

import java.util.ArrayList;
import java.util.List;

import javax.xml.crypto.dsig.spec.HMACParameterSpec;

import pulling.historical.prices.breakout.CandleStick;
import pulling.historical.prices.breakout.Utilities;

public class DisplayResults {
	
	double representResults = 0; 
	String percentSign = "%";
	
	public void displayHistory(List<CandleStick>candleStickList){
		if(candleStickList.size()<1) {
			Utilities.writeString("NO data to display");
			return;
		}
		Utilities.writeString("Date\t Time\t\tOpen\tHigh\tLow\tClose");
		for(pulling.historical.prices.breakout.CandleStick candleStick : candleStickList) {
			pulling.historical.prices.breakout.Utilities.writeString(candleStick.getDate() + "\t" +
					candleStick.getOpen() + "\t" + // the open bid for the candle
					candleStick.getHigh() + "\t" + // the high bid for the candle
					candleStick.getLow() + "\t"  + // the low bid for the candle 
					candleStick.getCloseBid ()   + // the close bid for the candle;
					candleStick.getCloseAsk());
		}
	}
	
	public void displayBestWinningsFromBacktesting(List <StrategyResult> strategySummary) {
		Utilities.writeString("10 best results ______________________________________________________________ ");
		for (int i = 0; i < 10; i++) {
			BreakoutStrategy bos = (BreakoutStrategy) strategySummary.get(i).getStrategy();
			Utilities.writeString("profit:"+representResults + percentSign +
					" | max-drawdown:"+(double)Math.round(strategySummary.get(i).getMaxDrawdown()*10000)/100 +"%" +
					" | wins:"+(double)Math.round(10000*strategySummary.get(i).getWinsRatio())/100 + "%" +
					" | losses:"+(double)Math.round(10000*strategySummary.get(i).getLossesRatio())/100 + "%" +
					" | s-l:"+(double)Math.round(bos.getSTOP_LOSS()*10000)/100 +"%" +
					" | t-p:"+(double)Math.round(bos.getTAKE_PROFIT()*10000)/100 +"%" +
					" | bottom-Donchian:"+bos.getFLOOR_DONCHIAN() +
					" | top-DOnchian:"+bos.getCEILING_DONCHIAN() + "\n");
		}
	}
	public void displayWorstWinningsFromBacktesting(List <StrategyResult> strategySummary) {
		Utilities.writeString("10 worst results _____________________________________________________________ ");
		for (int i = strategySummary.size()-1; i > strategySummary.size()-11; i--) {
			BreakoutStrategy bos = (BreakoutStrategy) strategySummary.get(i).getStrategy();
			Utilities.writeString("profit: "+representResults + percentSign +
					" | max-drawdown:"+(double)Math.round(strategySummary.get(i).getMaxDrawdown()*10000)/100 +"%" +
					" | wins:"+(double)Math.round(10000*strategySummary.get(i).getWinsRatio())/100 + "%" +
					" | losses:"+(double)Math.round(10000*strategySummary.get(i).getLossesRatio())/100 + "%" +
					" | s-l:"+(double)Math.round(bos.getSTOP_LOSS()*10000)/100 +"%" +
					" | t-p:"+(double)Math.round(bos.getTAKE_PROFIT()*10000)/100 +"%" +
					" | bottom-Donchian:"+bos.getFLOOR_DONCHIAN() +
					" | top-Donchian:"+bos.getCEILING_DONCHIAN() + "\n");
		}
	}
}
