package building.breakout.strategy;

import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import building.breakout.strategy.StrategyResult;
import pulling.historical.prices.breakout.CandleStick;
import pulling.historical.prices.breakout.Utilities;

public class BreakoutStrategy implements Strategy {

	private double STOP_LOSS;
	private double TAKE_PROFIT;
	public double FLOOR_DONCHIAN;
	public static double CEILING_DONCHIAN;
	//	static double upperDonchianChannel = 0 ;
	//	static double lowerDonchianChannel = 0; 
	//	static List<Double> candleStickLowPrices = new ArrayList<>();
	//	static List<Double> candleStickHighPrices = new ArrayList<>();
	//	List<CandleStick> candleSticksList;
	//	int duration;

	public BreakoutStrategy() {
	}

	public BreakoutStrategy(double stopLoss, double takeProfit, double floorDonchian) {
		super();
		STOP_LOSS = stopLoss;
		TAKE_PROFIT = takeProfit;
		FLOOR_DONCHIAN = floorDonchian;
		CEILING_DONCHIAN = 1+floorDonchian;
	}

	public static void calculateDonchianIndicatorForDataSet(List<CandleStick> candleSticksList, int duration){
		double donchianChannel = 0;
		double upperDonchianChannel = 0;
		double lowerDonchianChannel = 0;
		List<Double> candleStickLowPrices = new ArrayList<>();
		List<Double> candleStickHighPrices = new ArrayList<>();
		DonchianIndicator donchianInd = new DonchianIndicator();

		for (int i = 0; i < candleSticksList.size(); i++) {
			candleStickLowPrices.add(candleSticksList.get(i).getLow());
			candleStickHighPrices.add(candleSticksList.get(i).getHigh());

		}
		//		upperDonchianChannel = Utilities.addAllNumbers(candleStickLowPrices)/20;
		//		lowerDonchianChannel = Utilities.addAllNumbers(candleStickHighPrices)/20;
		//		donchianChannel = donchianInd.calculateDonchianIndicator(lowerDonchianChannel, upperDonchianChannel);
		System.out.println(donchianChannel + "Donchian Channnnnnnnnnnnnnnnnnnnnnnnnnnel");
		upperDonchianChannel = Utilities.addAllNumbers(candleStickLowPrices)/20;
		lowerDonchianChannel = Utilities.addAllNumbers(candleStickHighPrices)/20;
		donchianChannel = donchianInd.calculateDonchianIndicator(lowerDonchianChannel, upperDonchianChannel);
		for (CandleStick price : candleSticksList) {
			price.setDonchianChannel(donchianChannel);
		}
	}
	//	public double calculateDonchian(){
	//		double donchianChannel = 0;
	//		double upperDonchianChannel = 0;
	//		double lowerDonchianChannel = 0;
	//
	//		for (int i = 0; i < duration; i++) {
	//			candleStickLowPrices.add(candleSticksList.get(i).getLow());
	//			candleStickHighPrices.add(candleSticksList.get(i).getHigh());
	//		}
	//		List<Double> candleStickLowPrices = new ArrayList<>();
	//		List<Double> candleStickHighPrices = new ArrayList<>();
	//		DonchianIndicator donchianInd = new DonchianIndicator();
	//		upperDonchianChannel = Utilities.addAllNumbers(candleStickLowPrices)/20;
	//		lowerDonchianChannel = Utilities.addAllNumbers(candleStickHighPrices)/20;
	//		donchianChannel = donchianInd.calculateDonchianIndicator(lowerDonchianChannel, upperDonchianChannel);
	//		
	//		return donchianChannel;
	//	}
	//
	//	public double calculateUpperDonchian(List<CandleStick> candleSticksList, int duration) {
	//
	//		for (int i = 0; i < duration; i++) {
	//			candleStickLowPrices.add(candleSticksList.get(i).getLow());
	//		}
	//		upperDonchianChannel = Utilities.addAllNumbers(candleStickLowPrices)/20;
	//		System.out.println(upperDonchianChannel);
	//		return upperDonchianChannel;
	//	}

	//	public Double calculateLowerDonchian(List<CandleStick> candleSticksList, int duration) {
	//		DonchianIndicator donchianInd = new DonchianIndicator();
	//
	//		for (int i = 0; i < duration; i++) {
	//			candleStickLowPrices.add(candleSticksList.get(i).getLow());
	//		}
	//		lowerDonchianChannel = Utilities.addAllNumbers(candleStickHighPrices)/20;
	//		System.out.println(lowerDonchianChannel);
	//		return upperDonchianChannel;
	//	}




	@Override
	public StrategyResult runStrategy(List<CandleStick> candleSticksList) {

		double entryBuy;
		double entrySell;
		double stopLossPrice=0;
		double takeProfitPrice=0;
		double strategyProfit=0;
		double maxProfit=0;
		double maxDrawdown=0;
		boolean isOpenPosition=false;
		int winCounter=0;
		int lossCounter=0;


		for (int i = 250; i < candleSticksList.size(); i++) {

			if(isOpenPosition) {
				if(stopLossPrice<takeProfitPrice) {
					if(candleSticksList.get(i).getLow()<stopLossPrice) {
						isOpenPosition=false;
						lossCounter++;
						strategyProfit-=STOP_LOSS;
						maxDrawdown=calculateMaxDrawdown(maxProfit, strategyProfit, maxDrawdown);
					}else if(candleSticksList.get(i).getHigh()>takeProfitPrice) {
						isOpenPosition=false;
						winCounter++;
						strategyProfit+=TAKE_PROFIT;
						maxProfit=updateMaxProfit(strategyProfit,maxProfit);
					}
				}else {
					if(candleSticksList.get(i).getHigh()>stopLossPrice) {
						isOpenPosition=false;
						lossCounter++;
						strategyProfit-=STOP_LOSS;
					}else if(candleSticksList.get(i).getHigh()>stopLossPrice) {
						isOpenPosition=false;
						winCounter++;
						strategyProfit+=TAKE_PROFIT;
						maxProfit=updateMaxProfit(strategyProfit, maxProfit);
					}
				}
				//System.out.println(candleSticksList.get(i).getCCI() + "THis is the CCI for the FLOOR");
			}else if(candleSticksList.get(i).getDonchianChannel()<FLOOR_DONCHIAN) {
				entryBuy=candleSticksList.get(i).getCloseAsk();
				stopLossPrice= ((1-STOP_LOSS)*entryBuy);
				takeProfitPrice = ((1+TAKE_PROFIT)*entryBuy);
				isOpenPosition=true;
			}else if(candleSticksList.get(i).getDonchianChannel()>CEILING_DONCHIAN) {
				entrySell=candleSticksList.get(i).getCloseBid();
				stopLossPrice=((1+STOP_LOSS)*entrySell);
				takeProfitPrice=((1-TAKE_PROFIT)*entrySell);
				isOpenPosition=true;
			}
		}
		StrategyResult sr = new StrategyResult(strategyProfit, maxProfit, maxDrawdown, winCounter, lossCounter, this);

		return sr;
	}

	private double updateMaxProfit(double strategyProfit, double maxProfit) {

		if(strategyProfit>maxProfit) {
			maxProfit=strategyProfit;
		}

		return maxProfit;
	}

	private double calculateMaxDrawdown(double maxProfit, double strategyProfit, double maxDrawdown) {

		double currentDrawdown = ((1+strategyProfit) - (1+maxProfit))/(1+maxProfit);

		if (currentDrawdown<maxDrawdown) {
			maxDrawdown=currentDrawdown;
		}

		return maxDrawdown;
	}

	public double getSTOP_LOSS() {
		return STOP_LOSS;
	}

	public void setSTOP_LOSS(double sTOP_LOSS) {
		STOP_LOSS = sTOP_LOSS;
	}

	public double getTAKE_PROFIT() {
		return TAKE_PROFIT;
	}

	public void setTAKE_PROFIT(double tAKE_PROFIT) {
		TAKE_PROFIT = tAKE_PROFIT;
	}

	public double getFLOOR_DONCHIAN() {
		return FLOOR_DONCHIAN;
	}

	public void setFLOOR_DONCHIAN(int fLOOR_DONCHIAN) {
		FLOOR_DONCHIAN = fLOOR_DONCHIAN;
	}

	public double getCEILING_DONCHIAN() {
		return  CEILING_DONCHIAN;
	}

	public void setCEILING_DONCHIAN(int cEILING_DONCHIAN) {
		CEILING_DONCHIAN = cEILING_DONCHIAN;
	}

}
